/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.datagen;

import java.util.Objects;
import me.jddev0.epfd.block.EPFDBlocks;
import me.jddev0.epfd.block.ElectricStoveBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "energizedpowerfd", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerBlocks();
    }

    private void registerBlocks() {
        this.activatableOrientableBlockWithItem(EPFDBlocks.ELECTRIC_STOVE, this.orientableBlockModel(EPFDBlocks.ELECTRIC_STOVE, true), this.orientableBlockModel(EPFDBlocks.ELECTRIC_STOVE, "_on", "_top_on", "_bottom", "_front_on", "_side"), ElectricStoveBlock.LIT);
        this.activatableOrientableBlockWithItem(EPFDBlocks.INDUCTION_STOVE, this.orientableBlockModel(EPFDBlocks.INDUCTION_STOVE, true), this.orientableBlockModel(EPFDBlocks.INDUCTION_STOVE, "_on", "_top_on", "_bottom", "_front_on", "_side"), ElectricStoveBlock.LIT);
    }

    private ModelFile orientableBlockModel(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableBlockModel(block, "", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_side");
    }

    private ModelFile orientableBlockModel(RegistryObject<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String sideSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).m_135782_();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_() + fileSuffix, "block/orientable")).texture("particle", "#top")).texture("top", this.getBlockTexture(block, topSuffix))).texture("bottom", this.getBlockTexture(block, bottomSuffix))).texture("front", this.getBlockTexture(block, frontSuffix))).texture("side", this.getBlockTexture(block, sideSuffix));
    }

    private void activatableOrientableBlockWithItem(RegistryObject<? extends Block> block, ModelFile modelNormal, ModelFile modelActive, BooleanProperty isActiveProperty) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(180).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(180).modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(90).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(90).modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(270).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(270).modelFile(modelActive).addModel()).partialState();
        this.simpleBlockItem((Block)block.get(), modelNormal);
    }

    private ResourceLocation getBlockTexture(RegistryObject<? extends Block> block, String pathSuffix) {
        ResourceLocation blockId = block.getId();
        return new ResourceLocation(blockId.m_135827_(), "block/" + blockId.m_135815_() + pathSuffix);
    }
}

