/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.datagen;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.datagen.recipe.PlantGrowthChamberFinishedRecipe;
import me.jddev0.ep.datagen.recipe.SawmillFinishedRecipe;
import me.jddev0.ep.datagen.recipe.ShapedFinishedRecipe;
import me.jddev0.ep.datagen.recipe.ShapelessFinishedRecipe;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import me.jddev0.ep.registry.tags.CommonItemTags;
import me.jddev0.epfd.block.EPFDBlocks;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final String FARMERS_DELIGHT_MOD_ID = "farmersdelight";
    private static final String PATH_PREFIX = "compat/farmersdelight/";

    public ModRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> output) {
        this.buildCraftingRecipes(output);
        this.buildSawmillRecipes(output);
        this.buildPlantGrowthChamberRecipes(output);
    }

    private void buildCraftingRecipes(Consumer<FinishedRecipe> output) {
        this.buildMachineCraftingRecipes(output);
    }

    private void buildMachineCraftingRecipes(Consumer<FinishedRecipe> output) {
        ModRecipeProvider.addShapedCraftingRecipe(output, ModRecipeProvider.has((RegistryObject<Item>)EPBlocks.BASIC_MACHINE_FRAME_ITEM), Map.of(Character.valueOf('I'), Ingredient.m_204132_((TagKey)CommonItemTags.PLATES_IRON), Character.valueOf('R'), Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), Character.valueOf('B'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM.get()}), Character.valueOf('S'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.STOVE.get()})), new String[]{"ISI", "RBR", "ISI"}, new ItemStack((ItemLike)EPFDBlocks.ELECTRIC_STOVE_ITEM.get()), CraftingBookCategory.MISC);
        ModRecipeProvider.addShapedCraftingRecipe(output, ModRecipeProvider.has((RegistryObject<Item>)EPBlocks.HARDENED_MACHINE_FRAME_ITEM), Map.of(Character.valueOf('S'), Ingredient.m_204132_((TagKey)CommonItemTags.INGOTS_STEEL), Character.valueOf('B'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)EPItems.BASIC_CIRCUIT.get()}), Character.valueOf('H'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)EPBlocks.HARDENED_MACHINE_FRAME_ITEM.get()}), Character.valueOf('E'), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)EPFDBlocks.ELECTRIC_STOVE_ITEM.get()})), new String[]{"SES", "BHB", "SES"}, new ItemStack((ItemLike)EPFDBlocks.INDUCTION_STOVE_ITEM.get()), CraftingBookCategory.MISC);
    }

    private void buildSawmillRecipes(Consumer<FinishedRecipe> output) {
        this.addSawmillRecipe(output, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CUTTING_BOARD.get()}), new ItemStack((ItemLike)Items.f_42647_, 4), 2, "oak_planks", "cutting_board");
        this.addSawmillRecipe(output, Ingredient.m_204132_((TagKey)ModTags.WOODEN_CABINETS), new ItemStack((ItemLike)Items.f_42398_, 10), 3, "sticks", "cabinets");
    }

    private void buildPlantGrowthChamberRecipes(Consumer<FinishedRecipe> output) {
        this.addPlantGrowthChamberRecipe(output, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_SEEDS.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.TOMATO_SEEDS.get()), new double[]{1.0}), new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.TOMATO.get()), new double[]{1.0, 0.75, 0.5, 0.25}), new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.ROTTEN_TOMATO.get()), new double[]{0.05})}, 16000, "tomatoes", "tomato_seeds");
        this.addPlantGrowthChamberRecipe(output, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ONION.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.ONION.get()), new double[]{1.0, 0.75, 0.25, 0.25})}, 16000, "onions", "onion");
        this.addPlantGrowthChamberRecipe(output, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE_SEEDS.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.CABBAGE_SEEDS.get()), new double[]{1.0, 0.33, 0.33}), new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.CABBAGE.get()), new double[]{1.0, 0.75, 0.25, 0.25})}, 16000, "cabbage", "cabbage_seeds");
    }

    private static void addShapedCraftingRecipe(Consumer<FinishedRecipe> output, InventoryChangeTrigger.TriggerInstance hasIngredientTrigger, Map<Character, Ingredient> key, String[] pattern, ItemStack result, CraftingBookCategory category) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, "");
    }

    private static void addShapedCraftingRecipe(Consumer<FinishedRecipe> output, InventoryChangeTrigger.TriggerInstance hasIngredientTrigger, Map<Character, Ingredient> key, String[] pattern, ItemStack result, CraftingBookCategory category, String group) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, group, "");
    }

    private static void addShapedCraftingRecipe(Consumer<FinishedRecipe> output, InventoryChangeTrigger.TriggerInstance hasIngredientTrigger, Map<Character, Ingredient> key, String[] pattern, ItemStack result, CraftingBookCategory category, String group, String recipeIdSuffix) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, group, recipeIdSuffix, "");
    }

    private static void addShapedCraftingRecipe(Consumer<FinishedRecipe> output, InventoryChangeTrigger.TriggerInstance hasIngredientTrigger, Map<Character, Ingredient> key, String[] pattern, ItemStack result, CraftingBookCategory category, String group, String recipeIdSuffix, String recipeIdPrefix) {
        ResourceLocation recipeId = new ResourceLocation("energizedpowerfd", "compat/farmersdelight/crafting/" + recipeIdPrefix + ModRecipeProvider.m_176632_((ItemLike)result.m_41720_()) + recipeIdSuffix);
        Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_().m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138386_("has_the_ingredient", (CriterionTriggerInstance)hasIngredientTrigger).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        ShapedFinishedRecipe recipe = new ShapedFinishedRecipe(recipeId, Objects.requireNonNullElse(group, ""), category, key, pattern, result, advancementBuilder, recipeId.m_246208_("recipes/"));
        output.accept((FinishedRecipe)recipe);
    }

    private static void addShapelessCraftingRecipe(Consumer<FinishedRecipe> output, InventoryChangeTrigger.TriggerInstance hasIngredientTrigger, List<Ingredient> inputs, ItemStack result, CraftingBookCategory category) {
        ModRecipeProvider.addShapelessCraftingRecipe(output, hasIngredientTrigger, inputs, result, category, "");
    }

    private static void addShapelessCraftingRecipe(Consumer<FinishedRecipe> output, InventoryChangeTrigger.TriggerInstance hasIngredientTrigger, List<Ingredient> inputs, ItemStack result, CraftingBookCategory category, String group) {
        ModRecipeProvider.addShapelessCraftingRecipe(output, hasIngredientTrigger, inputs, result, category, group, "");
    }

    private static void addShapelessCraftingRecipe(Consumer<FinishedRecipe> output, InventoryChangeTrigger.TriggerInstance hasIngredientTrigger, List<Ingredient> inputs, ItemStack result, CraftingBookCategory category, String group, String recipeIdSuffix) {
        ModRecipeProvider.addShapelessCraftingRecipe(output, hasIngredientTrigger, inputs, result, category, group, recipeIdSuffix, "");
    }

    private static void addShapelessCraftingRecipe(Consumer<FinishedRecipe> output, InventoryChangeTrigger.TriggerInstance hasIngredientTrigger, List<Ingredient> inputs, ItemStack result, CraftingBookCategory category, String group, String recipeIdSuffix, String recipeIdPrefix) {
        ResourceLocation recipeId = new ResourceLocation("energizedpowerfd", "compat/farmersdelight/crafting/" + recipeIdPrefix + ModRecipeProvider.m_176632_((ItemLike)result.m_41720_()) + recipeIdSuffix);
        Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_().m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138386_("has_the_ingredient", (CriterionTriggerInstance)hasIngredientTrigger).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        ShapelessFinishedRecipe recipe = new ShapelessFinishedRecipe(recipeId, Objects.requireNonNullElse(group, ""), category, result, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])inputs.toArray(Ingredient[]::new))), advancementBuilder, recipeId.m_246208_("recipes/"));
        output.accept((FinishedRecipe)recipe);
    }

    private void addSawmillRecipe(Consumer<FinishedRecipe> recipeOutput, Ingredient input, ItemStack output, int sawdustAmount, String outputName, String recipeIngredientName) {
        ResourceLocation recipeId = new ResourceLocation("energizedpowerfd", "compat/farmersdelight/sawmill/" + outputName + "_from_sawing_" + recipeIngredientName);
        SawmillFinishedRecipe recipe = new SawmillFinishedRecipe(recipeId, output, input, sawdustAmount);
        recipeOutput.accept((FinishedRecipe)recipe);
    }

    private void addPlantGrowthChamberRecipe(Consumer<FinishedRecipe> recipeOutput, Ingredient input, OutputItemStackWithPercentages[] outputs, int ticks, String outputName, String recipeIngredientName) {
        ResourceLocation recipeId = new ResourceLocation("energizedpowerfd", "compat/farmersdelight/growing/" + outputName + "_from_growing_" + recipeIngredientName);
        PlantGrowthChamberFinishedRecipe recipe = new PlantGrowthChamberFinishedRecipe(recipeId, outputs, input, ticks);
        recipeOutput.accept((FinishedRecipe)recipe);
    }

    private static InventoryChangeTrigger.TriggerInstance has(RegistryObject<Item> item) {
        return ModRecipeProvider.m_125977_((ItemLike)((ItemLike)item.get()));
    }
}

