/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.mixin;

import me.jddev0.epfd.utils.CookingUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.tag.ModTags;

@Mixin(value={CookingPotBlockEntity.class})
public abstract class CookingPotBlockEntityMixin
extends SyncedBlockEntity
implements HeatableBlockEntity {
    @Shadow
    private int cookTime;

    public CookingPotBlockEntityMixin(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Inject(method={"processCooking"}, at={@At(value="HEAD")}, remap=false)
    private void processCooking(CookingPotRecipe recipe, CookingPotBlockEntity cookingPot, CallbackInfoReturnable<Boolean> cir) {
        int speedMultiplier;
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos heatSourcePos = this.f_58858_.m_7495_();
        BlockState heatSourceState = this.f_58857_.m_8055_(heatSourcePos);
        if (!this.requiresDirectHeat() && !heatSourceState.m_204336_(ModTags.HEAT_SOURCES) && heatSourceState.m_204336_(ModTags.HEAT_CONDUCTORS)) {
            heatSourcePos = heatSourcePos.m_7495_();
            heatSourceState = this.f_58857_.m_8055_(heatSourcePos);
        }
        if ((speedMultiplier = CookingUtils.getSpeedMultiplierForHeatSource(heatSourceState)) != -1) {
            this.cookTime += speedMultiplier - 1;
        }
    }
}

