/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.mixin;

import me.jddev0.epfd.utils.CookingUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.tag.ModTags;

@Mixin(value={SkilletBlockEntity.class})
public abstract class SkilletBlockEntityMixin
extends SyncedBlockEntity
implements HeatableBlockEntity {
    @Shadow
    private int cookingTime;

    public SkilletBlockEntityMixin(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Inject(method={"cookAndOutputItems"}, at={@At(value="HEAD")}, remap=false)
    private void cookAndOutputItems(ItemStack cookingStack, Level level, CallbackInfo ci) {
        int speedMultiplier;
        if (level == null) {
            return;
        }
        BlockPos heatSourcePos = this.f_58858_.m_7495_();
        BlockState heatSourceState = level.m_8055_(heatSourcePos);
        if (!this.requiresDirectHeat() && !heatSourceState.m_204336_(ModTags.HEAT_SOURCES) && heatSourceState.m_204336_(ModTags.HEAT_CONDUCTORS)) {
            heatSourcePos = heatSourcePos.m_7495_();
            heatSourceState = level.m_8055_(heatSourcePos);
        }
        if ((speedMultiplier = CookingUtils.getSpeedMultiplierForHeatSource(heatSourceState)) != -1) {
            this.cookingTime += speedMultiplier - 1;
        }
    }
}

