/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import me.jddev0.epfd.block.AbstractStoveBlock;
import me.jddev0.epfd.block.entity.AbstractStoveBlockEntity;
import me.jddev0.epfd.block.entity.EPFDBlockEntities;
import me.jddev0.epfd.block.entity.InductionStoveBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InductionStoveBlock
extends AbstractStoveBlock {
    public static final MapCodec<InductionStoveBlock> CODEC = InductionStoveBlock.simpleCodec(InductionStoveBlock::new);

    protected InductionStoveBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new InductionStoveBlockEntity(blockPos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return InductionStoveBlock.createTickerHelper(type, EPFDBlockEntities.INDUCTION_STOVE_ENTITY.get(), AbstractStoveBlockEntity::tick);
    }

    public static class Item
    extends BlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpowerfd.stoves.txt.shift.1", (Object[])new Object[]{Component.translatable((String)this.getDescriptionId(itemStack)), InductionStoveBlockEntity.RECIPE_DURATION_MULTIPLIER}).withStyle(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

