/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.datagen;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import me.jddev0.ep.recipe.SawmillRecipe;
import me.jddev0.ep.registry.tags.CommonItemTags;
import me.jddev0.epfd.block.EPFDBlocks;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final String FARMERS_DELIGHT_MOD_ID = "farmersdelight";
    private static final String PATH_PREFIX = "compat/farmersdelight/";

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.buildCraftingRecipes(output);
        this.buildSawmillRecipes(output);
        this.buildPlantGrowthChamberRecipes(output);
    }

    private void buildCraftingRecipes(RecipeOutput output) {
        this.buildMachineCraftingRecipes(output);
    }

    private void buildMachineCraftingRecipes(RecipeOutput output) {
        ModRecipeProvider.addShapedCraftingRecipe(output, (Criterion<InventoryChangeTrigger.TriggerInstance>)ModRecipeProvider.has((ItemLike)EPBlocks.BASIC_MACHINE_FRAME_ITEM), Map.of(Character.valueOf('I'), Ingredient.of((TagKey)CommonItemTags.PLATES_IRON), Character.valueOf('R'), Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), Character.valueOf('B'), Ingredient.of((ItemLike[])new ItemLike[]{EPBlocks.BASIC_MACHINE_FRAME_ITEM}), Character.valueOf('S'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.STOVE.get()})), new String[]{"ISI", "RBR", "ISI"}, new ItemStack((ItemLike)EPFDBlocks.ELECTRIC_STOVE_ITEM.get()), CraftingBookCategory.MISC);
        ModRecipeProvider.addShapedCraftingRecipe(output, (Criterion<InventoryChangeTrigger.TriggerInstance>)ModRecipeProvider.has((ItemLike)EPBlocks.HARDENED_MACHINE_FRAME_ITEM), Map.of(Character.valueOf('S'), Ingredient.of((TagKey)CommonItemTags.INGOTS_STEEL), Character.valueOf('B'), Ingredient.of((ItemLike[])new ItemLike[]{EPItems.BASIC_CIRCUIT}), Character.valueOf('H'), Ingredient.of((ItemLike[])new ItemLike[]{EPBlocks.HARDENED_MACHINE_FRAME_ITEM}), Character.valueOf('E'), Ingredient.of((ItemLike[])new ItemLike[]{EPFDBlocks.ELECTRIC_STOVE_ITEM})), new String[]{"SES", "BHB", "SES"}, new ItemStack((ItemLike)EPFDBlocks.INDUCTION_STOVE_ITEM.get()), CraftingBookCategory.MISC);
    }

    private void buildSawmillRecipes(RecipeOutput output) {
        this.addSawmillRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CUTTING_BOARD.get()}), new ItemStack((ItemLike)Items.OAK_PLANKS, 4), 2, "oak_planks", "cutting_board");
        this.addSawmillRecipe(output, Ingredient.of((TagKey)ModTags.WOODEN_CABINETS), new ItemStack((ItemLike)Items.STICK, 10), 3, "sticks", "cabinets");
    }

    private void buildPlantGrowthChamberRecipes(RecipeOutput output) {
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_SEEDS.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.TOMATO_SEEDS.get()), new double[]{1.0}), new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.TOMATO.get()), new double[]{1.0, 0.75, 0.5, 0.25}), new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.ROTTEN_TOMATO.get()), new double[]{0.05})}, 16000, "tomatoes", "tomato_seeds");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ONION.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.ONION.get()), new double[]{1.0, 0.75, 0.25, 0.25})}, 16000, "onions", "onion");
        this.addPlantGrowthChamberRecipe(output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE_SEEDS.get()}), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.CABBAGE_SEEDS.get()), new double[]{1.0, 0.33, 0.33}), new OutputItemStackWithPercentages(new ItemStack((ItemLike)ModItems.CABBAGE.get()), new double[]{1.0, 0.75, 0.25, 0.25})}, 16000, "cabbage", "cabbage_seeds");
    }

    private static void addShapedCraftingRecipe(RecipeOutput output, Criterion<InventoryChangeTrigger.TriggerInstance> hasIngredientTrigger, Map<Character, Ingredient> key, String[] pattern, ItemStack result, CraftingBookCategory category) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, "");
    }

    private static void addShapedCraftingRecipe(RecipeOutput output, Criterion<InventoryChangeTrigger.TriggerInstance> hasIngredientTrigger, Map<Character, Ingredient> key, String[] pattern, ItemStack result, CraftingBookCategory category, String group) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, group, "");
    }

    private static void addShapedCraftingRecipe(RecipeOutput output, Criterion<InventoryChangeTrigger.TriggerInstance> hasIngredientTrigger, Map<Character, Ingredient> key, String[] pattern, ItemStack result, CraftingBookCategory category, String group, String recipeIdSuffix) {
        ModRecipeProvider.addShapedCraftingRecipe(output, hasIngredientTrigger, key, pattern, result, category, group, recipeIdSuffix, "");
    }

    private static void addShapedCraftingRecipe(RecipeOutput output, Criterion<InventoryChangeTrigger.TriggerInstance> hasIngredientTrigger, Map<Character, Ingredient> key, String[] pattern, ItemStack result, CraftingBookCategory category, String group, String recipeIdSuffix, String recipeIdPrefix) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerfd", (String)("compat/farmersdelight/crafting/" + recipeIdPrefix + ModRecipeProvider.getItemName((ItemLike)result.getItem()) + recipeIdSuffix));
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).addCriterion("has_the_ingredient", hasIngredientTrigger).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        ShapedRecipe recipe = new ShapedRecipe(Objects.requireNonNullElse(group, ""), category, ShapedRecipePattern.of(key, (String[])pattern), result);
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(recipeId.withPrefix("recipes/")));
    }

    private static void addShapelessCraftingRecipe(RecipeOutput output, Criterion<InventoryChangeTrigger.TriggerInstance> hasIngredientTrigger, List<Ingredient> inputs, ItemStack result, CraftingBookCategory category) {
        ModRecipeProvider.addShapelessCraftingRecipe(output, hasIngredientTrigger, inputs, result, category, "");
    }

    private static void addShapelessCraftingRecipe(RecipeOutput output, Criterion<InventoryChangeTrigger.TriggerInstance> hasIngredientTrigger, List<Ingredient> inputs, ItemStack result, CraftingBookCategory category, String group) {
        ModRecipeProvider.addShapelessCraftingRecipe(output, hasIngredientTrigger, inputs, result, category, group, "");
    }

    private static void addShapelessCraftingRecipe(RecipeOutput output, Criterion<InventoryChangeTrigger.TriggerInstance> hasIngredientTrigger, List<Ingredient> inputs, ItemStack result, CraftingBookCategory category, String group, String recipeIdSuffix) {
        ModRecipeProvider.addShapelessCraftingRecipe(output, hasIngredientTrigger, inputs, result, category, group, recipeIdSuffix, "");
    }

    private static void addShapelessCraftingRecipe(RecipeOutput output, Criterion<InventoryChangeTrigger.TriggerInstance> hasIngredientTrigger, List<Ingredient> inputs, ItemStack result, CraftingBookCategory category, String group, String recipeIdSuffix, String recipeIdPrefix) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerfd", (String)("compat/farmersdelight/crafting/" + recipeIdPrefix + ModRecipeProvider.getItemName((ItemLike)result.getItem()) + recipeIdSuffix));
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).addCriterion("has_the_ingredient", hasIngredientTrigger).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        ShapelessRecipe recipe = new ShapelessRecipe(Objects.requireNonNullElse(group, ""), category, result, NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])inputs.toArray(Ingredient[]::new))));
        output.accept(recipeId, (Recipe)recipe, advancementBuilder.build(recipeId.withPrefix("recipes/")));
    }

    private void addSawmillRecipe(RecipeOutput recipeOutput, Ingredient input, ItemStack output, int sawdustAmount, String outputName, String recipeIngredientName) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerfd", (String)("compat/farmersdelight/sawmill/" + outputName + "_from_sawing_" + recipeIngredientName));
        SawmillRecipe recipe = new SawmillRecipe(output, input, sawdustAmount);
        recipeOutput.accept(recipeId, (Recipe)recipe, null, new ICondition[]{this.modLoaded(FARMERS_DELIGHT_MOD_ID)});
    }

    private void addPlantGrowthChamberRecipe(RecipeOutput recipeOutput, Ingredient input, OutputItemStackWithPercentages[] outputs, int ticks, String outputName, String recipeIngredientName) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerfd", (String)("compat/farmersdelight/growing/" + outputName + "_from_growing_" + recipeIngredientName));
        PlantGrowthChamberRecipe recipe = new PlantGrowthChamberRecipe(outputs, input, ticks);
        recipeOutput.accept(recipeId, (Recipe)recipe, null, new ICondition[]{this.modLoaded(FARMERS_DELIGHT_MOD_ID)});
    }
}

