/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.block.entity;

import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.epfd.block.entity.base.ConfigurableUpgradableEnergyStorageBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;

public abstract class AbstractStoveBlockEntity
extends ConfigurableUpgradableEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage> {
    protected final int baseEnergyConsumptionPerTick;
    protected boolean hasEnoughEnergy;
    protected int timeoutOffState;

    public AbstractStoveBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, int baseEnergyCapacity, int baseEnergyTransferRate, int baseEnergyConsumptionPerTick) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.baseEnergyConsumptionPerTick = baseEnergyConsumptionPerTick;
    }

    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AbstractStoveBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AbstractStoveBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            protected void onChange() {
                AbstractStoveBlockEntity.this.setChanged();
                AbstractStoveBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> AbstractStoveBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        AbstractStoveBlockEntity.this.redstoneMode = RedstoneMode.fromIndex((int)value);
                    }
                }
            }

            public int getCount() {
                return 1;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)("container.energizedpowerfd." + this.machineName));
    }

    public int getRedstoneOutput() {
        return EnergyUtils.getRedstoneSignalFromEnergyStorage((IEnergyStorage)this.energyStorage);
    }

    protected void litBlock() {
        if (this.level.getBlockState(this.getBlockPos()).hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    protected void unlitBlock() {
        if (this.level.getBlockState(this.getBlockPos()).hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AbstractStoveBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.timeoutOffState > 0) {
            --blockEntity.timeoutOffState;
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.unlitBlock();
                AbstractStoveBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        }
        if (!blockEntity.redstoneMode.isActive(((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue())) {
            blockEntity.unlitBlock();
            return;
        }
        if (blockEntity.hasSkilletOrCookingPot()) {
            int energyConsumptionPerTick = Math.max(1, (int)Math.ceil((double)blockEntity.baseEnergyConsumptionPerTick * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (energyConsumptionPerTick <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                blockEntity.hasEnoughEnergy = true;
                blockEntity.timeoutOffState = 0;
                blockEntity.litBlock();
                ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                AbstractStoveBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                if (blockEntity.timeoutOffState == 0) {
                    blockEntity.timeoutOffState = (Integer)ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
                }
                AbstractStoveBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.timeoutOffState = (Integer)ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
            }
            AbstractStoveBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private boolean hasSkilletOrCookingPot() {
        BlockPos testPos = this.worldPosition.above();
        BlockState testState = this.level.getBlockState(testPos);
        if (testState.is(ModTags.HEAT_CONDUCTORS)) {
            testPos = testPos.above();
            testState = this.level.getBlockState(testPos);
        }
        return testState.is((Block)ModBlocks.SKILLET.get()) || testState.is((Block)ModBlocks.COOKING_POT.get());
    }
}

