/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epfd.screen;

import me.jddev0.ep.inventory.UpgradeModuleSlot;
import me.jddev0.ep.inventory.upgrade.UpgradeModuleInventory;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.base.IConfigurableMenu;
import me.jddev0.ep.screen.base.UpgradableEnergyStorageMenu;
import me.jddev0.epfd.block.entity.AbstractStoveBlockEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractStoveMenu<T extends AbstractStoveBlockEntity>
extends UpgradableEnergyStorageMenu<T>
implements IConfigurableMenu {
    protected final ContainerData data;

    public AbstractStoveMenu(int id, Inventory inv, FriendlyByteBuf buffer, MenuType<?> menuType, Block block) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), menuType, block, new UpgradeModuleInventory(new UpgradeModuleModifier[]{UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY}), (ContainerData)new SimpleContainerData(1));
    }

    public AbstractStoveMenu(int id, Inventory inv, BlockEntity blockEntity, MenuType<?> menuType, Block block, UpgradeModuleInventory upgradeModuleInventory, ContainerData data) {
        super(menuType, id, inv, blockEntity, block, upgradeModuleInventory, 2);
        AbstractStoveMenu.checkContainerDataCount((ContainerData)data, (int)1);
        this.data = data;
        for (int i = 0; i < upgradeModuleInventory.getContainerSize(); ++i) {
            this.addSlot((Slot)new UpgradeModuleSlot((Container)upgradeModuleInventory, i, 71 + i * 18, 35, () -> ((AbstractStoveMenu)this).isInUpgradeModuleView()));
        }
        this.addDataSlots(this.data);
    }

    public RedstoneMode getRedstoneMode() {
        return RedstoneMode.fromIndex((int)this.data.get(0));
    }

    public ComparatorMode getComparatorMode() {
        return ComparatorMode.ENERGY;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 36, 38, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 38) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }
}

