/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.colored;

import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.CoreDataComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredDoor
extends DoorBlock
implements IColored {
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public ColoredDoor(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(blockSetType, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(COLOR, (Comparable)DyeColor.WHITE)).setValue((Property)LIT, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR, LIT, HALF, FACING, OPEN, HINGE, POWERED});
    }

    @Override
    public int getColor(int index) {
        DyeColor color = DyeColor.values()[index % DyeColor.values().length];
        return ColorMap.getColorValue(color);
    }

    @Override
    public int getColor(int index, ItemStack stack) {
        return this.getColor(index);
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        DyeColor color = (DyeColor)state.getValue(COLOR);
        for (ItemStack drop : drops) {
            if (!(drop.getItem() instanceof BlockItem) || ((BlockItem)drop.getItem()).getBlock() != this) continue;
            drop.set(CoreDataComponents.COLOR, (Object)color.toString());
            drop.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.getBlock() instanceof ColoredDoor) {
            DyeColor color = (DyeColor)state.getValue(COLOR);
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set(CoreDataComponents.COLOR, (Object)color.toString());
            stack.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (stack.get(CoreDataComponents.COLOR) != null && stack.get(CoreDataComponents.LIT) != null) {
            String colorString = (String)stack.get(CoreDataComponents.COLOR);
            assert (colorString != null);
            DyeColor dyeColor = ColorMap.getDyeColor(colorString);
            Boolean lit = (Boolean)stack.get(CoreDataComponents.LIT);
            assert (lit != null);
            BlockState newState = (BlockState)((BlockState)state.setValue(COLOR, (Comparable)dyeColor)).setValue((Property)LIT, (Comparable)lit);
            level.setBlockAndUpdate(pos, newState);
        } else {
            level.setBlockAndUpdate(pos, state);
        }
    }
}

