/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.event;

import com.benbenlaw.core.config.CoreModpackConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

@EventBusSubscriber(modid="bblcore", value={Dist.CLIENT})
public class UpdateCheckerEvent {
    private static final String PREFIX = "https://api.curseforge.com";
    private static final String apiKey = "$2a$10$Y64bw4w0RYpXpu9d9bEu7ulQSgP3MzXPm6rfmhEbqhnHf3oa8WOEq";
    private static final Path curseforgeMinecraftInstanceFileLocation = Path.of("minecraftinstance.json", new String[0]);
    private static final int projectID = (Integer)CoreModpackConfig.projectID.get();

    @SubscribeEvent
    public static void onPlayerLoggingInEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        block34: {
            LocalPlayer player = event.getPlayer();
            if (((Boolean)CoreModpackConfig.updateChecker.get()).booleanValue()) {
                if (Files.exists(curseforgeMinecraftInstanceFileLocation, new LinkOption[0])) {
                    try {
                        HttpsURLConnection connection;
                        int currentVersion;
                        BufferedReader reader;
                        block32: {
                            block33: {
                                block30: {
                                    block31: {
                                        JsonElement installedModpackElement;
                                        block28: {
                                            block29: {
                                                JsonElement parsed;
                                                block26: {
                                                    block27: {
                                                        reader = Files.newBufferedReader(curseforgeMinecraftInstanceFileLocation);
                                                        parsed = JsonParser.parseReader((Reader)reader);
                                                        if (parsed.isJsonObject()) break block26;
                                                        System.out.println("Instance file does not contain a valid JSON object.");
                                                        player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.modpack_invalid_instance").withStyle(ChatFormatting.RED));
                                                        if (reader == null) break block27;
                                                        ((Reader)reader).close();
                                                    }
                                                    return;
                                                }
                                                JsonObject dataObjectInstance = parsed.getAsJsonObject();
                                                installedModpackElement = dataObjectInstance.get("installedModpack");
                                                if (!installedModpackElement.isJsonNull()) break block28;
                                                System.out.println("No modpack is installed (Dev Environment).");
                                                player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.dev_environment").withStyle(ChatFormatting.YELLOW));
                                                if (reader == null) break block29;
                                                ((Reader)reader).close();
                                            }
                                            return;
                                        }
                                        JsonObject installedModpack = installedModpackElement.getAsJsonObject();
                                        currentVersion = 0;
                                        if (installedModpack.has("latestFile") && installedModpack.getAsJsonObject("latestFile").has("id")) {
                                            currentVersion = installedModpack.getAsJsonObject("latestFile").get("id").getAsInt();
                                            System.out.println("Installed File ID from instance: " + currentVersion);
                                            break block30;
                                        }
                                        System.out.println("Could not find latestFile.id in instance file.");
                                        player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.modpack_no_version").withStyle(ChatFormatting.RED));
                                        if (reader == null) break block31;
                                        ((Reader)reader).close();
                                    }
                                    return;
                                }
                                connection = (HttpsURLConnection)new URL("https://api.curseforge.com/v1/mods/" + projectID).openConnection();
                                connection.addRequestProperty("x-api-key", apiKey);
                                connection.setRequestMethod("GET");
                                if (connection.getResponseCode() == 200) break block32;
                                System.out.println("Unable to establish connection to API! Code " + connection.getResponseCode());
                                if (connection.getResponseCode() == 403) {
                                    System.out.println("(Are you sure the key is valid?)");
                                }
                                if (reader == null) break block33;
                                ((Reader)reader).close();
                            }
                            return;
                        }
                        try {
                            try {
                                String inputLine;
                                StringBuilder response = new StringBuilder();
                                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                                while ((inputLine = in.readLine()) != null) {
                                    response.append(inputLine);
                                }
                                in.close();
                                JsonObject jsonObject = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                                JsonObject dataObject = jsonObject.getAsJsonObject("data");
                                JsonArray latestFilesIndexes = dataObject.getAsJsonArray("latestFilesIndexes");
                                String modpackName = dataObject.get("name").getAsString();
                                String url = dataObject.getAsJsonObject("links").get("websiteUrl").getAsString();
                                int latestFileId = 0;
                                if (latestFilesIndexes != null && !latestFilesIndexes.isEmpty()) {
                                    JsonObject firstEntry = latestFilesIndexes.get(0).getAsJsonObject();
                                    if (firstEntry.has("fileId")) {
                                        latestFileId = firstEntry.get("fileId").getAsInt();
                                        System.out.println("Latest file ID from API: " + latestFileId);
                                    } else {
                                        System.out.println("fileId not found in the first entry.");
                                    }
                                } else {
                                    System.out.println("latestFilesIndexes is missing or empty.");
                                }
                                if (currentVersion == 0) {
                                    player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.modpack_no_version").withStyle(ChatFormatting.RED));
                                    break block34;
                                }
                                if (currentVersion < latestFileId) {
                                    player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.modpack_update", (Object[])new Object[]{modpackName}).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.bblcore.modpack_website")))).withStyle(ChatFormatting.BLUE));
                                    break block34;
                                }
                                player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.modpack_up_to_date").withStyle(ChatFormatting.GREEN));
                            }
                            catch (IOException e) {
                                System.out.println("Error while connecting to the API: " + e.getMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Error reading the instance file: " + e.getMessage());
                        player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.modpack_instance_error").withStyle(ChatFormatting.RED));
                    }
                } else {
                    System.out.println("CurseForge instance file not found.");
                    player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.modpack_no_instance").withStyle(ChatFormatting.RED));
                }
            }
        }
    }
}

