/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.item.colored;

import com.benbenlaw.core.block.brightable.IBrightable;
import com.benbenlaw.core.block.colored.ColoredBlock;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.TooltipUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class LightingItem
extends Item {
    public LightingItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (itemStack.isDamageableItem()) {
            ItemStack stackInCraftingTable = itemStack.copy();
            stackInCraftingTable.setDamageValue(stackInCraftingTable.getDamageValue() + 1);
            if (stackInCraftingTable.getDamageValue() >= stackInCraftingTable.getMaxDamage()) {
                return ItemStack.EMPTY;
            }
            return stackInCraftingTable;
        }
        return super.getCraftingRemainingItem(itemStack);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof IBrightable) {
            Property litProperty = state.getBlock().getStateDefinition().getProperty("lit");
            if (litProperty != null) {
                boolean isLit = (Boolean)state.getValue(litProperty);
                if (isLit) {
                    level.setBlock(pos, (BlockState)state.setValue(litProperty, (Comparable)Boolean.valueOf(false)), 3);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue(litProperty, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
            if (stack.isDamageableItem()) {
                assert (player != null);
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            } else {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (state.getBlock() instanceof IColored) {
            Block block = state.getBlock();
            Property colorProperty = block.getStateDefinition().getProperty("color");
            if (colorProperty != null) {
                if (((Boolean)state.getValue((Property)ColoredBlock.LIT)).booleanValue()) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)ColoredBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)ColoredBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
            if (stack.isDamageableItem()) {
                assert (player != null);
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            } else {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag flag) {
        TooltipUtil.addShiftTooltip(list, "tooltips.lighting_item.shift.held");
        list.add((Component)Component.literal((String)"Ability: Lights Blocks").withStyle(ChatFormatting.YELLOW));
    }

    @NotNull
    public Component getName(ItemStack stack) {
        StringBuilder nameBuilder = new StringBuilder(super.getName(stack).getString());
        return Component.literal((String)nameBuilder.toString()).withStyle(ChatFormatting.YELLOW);
    }
}

