/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import org.joml.Vector3f;
import org.lwjgl.stb.STBTTBitmap;

public class RenderUtil {
    public static void renderFace(Direction face, PoseStack.Pose pose, VertexConsumer consumer, TextureAtlasSprite texture, float x, float y, float z, float w, float h, int color) {
        RenderUtil.renderFace(face, pose, consumer, texture, x, y, z, w, h, color, 0xF000F0);
    }

    public static void renderFace(Direction face, PoseStack.Pose pose, VertexConsumer consumer, TextureAtlasSprite texture, float x, float y, float z, float w, float h, int color, int light) {
        switch (face) {
            case DOWN: {
                RenderUtil.renderFace(pose, consumer, texture, color, light, x, x + w, 1.0f - z, 1.0f - z, y, y, y + h, y + h, x, x + w, y, y + h, 0.0f, -1.0f, 0.0f);
                break;
            }
            case UP: {
                RenderUtil.renderFace(pose, consumer, texture, color, light, x, x + w, z, z, y + h, y + h, y, y, x, x + w, y, y + h, 0.0f, 1.0f, 0.0f);
                break;
            }
            case NORTH: {
                RenderUtil.renderFace(pose, consumer, texture, color, light, x, x + w, y + h, y, z, z, z, z, x, x + w, y, y + h, 0.0f, 0.0f, -1.0f);
                break;
            }
            case SOUTH: {
                RenderUtil.renderFace(pose, consumer, texture, color, light, x, x + w, y, y + h, 1.0f - z, 1.0f - z, 1.0f - z, 1.0f - z, x + w, x, y + h, y, 0.0f, 0.0f, 1.0f);
                break;
            }
            case EAST: {
                RenderUtil.renderFace(pose, consumer, texture, color, light, 1.0f - z, 1.0f - z, y + h, y, x, x + w, x + w, x, x, x + w, y, y + h, 1.0f, 0.0f, 0.0f);
                break;
            }
            case WEST: {
                RenderUtil.renderFace(pose, consumer, texture, color, light, z, z, y, y + h, x, x + w, x + w, x, x + w, x, y + h, y, -1.0f, 0.0f, 0.0f);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(face));
            }
        }
    }

    private static void renderFace(PoseStack.Pose pose, VertexConsumer consumer, TextureAtlasSprite texture, int color, int light, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, float u0, float u1, float v0, float v1, float normalX, float normalY, float normalZ) {
        float minU = u0 * (float)texture.contents().width() / 16.0f;
        float maxU = u1 * (float)texture.contents().width() / 16.0f;
        float minV = v0 * (float)texture.contents().height() / 16.0f;
        float maxV = v1 * (float)texture.contents().height() / 16.0f;
        consumer.addVertex(pose, x0, y0, z0).setColor(color).setUv(texture.getU(minU), texture.getV(minV)).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, normalX, normalY, normalZ);
        consumer.addVertex(pose, x1, y0, z1).setColor(color).setUv(texture.getU(maxU), texture.getV(minV)).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, normalX, normalY, normalZ);
        consumer.addVertex(pose, x1, y1, z2).setColor(color).setUv(texture.getU(maxU), texture.getV(maxV)).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, normalX, normalY, normalZ);
        consumer.addVertex(pose, x0, y1, z3).setColor(color).setUv(texture.getU(minU), texture.getV(maxV)).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, normalX, normalY, normalZ);
    }

    public static float[] unpackVertices(int[] vertices, int vertexIndex, int position, int count) {
        float[] floats = new float[count];
        int startIndex = vertexIndex * IQuadTransformer.STRIDE + position;
        for (int i = 0; i < count; ++i) {
            floats[i] = Float.intBitsToFloat(vertices[startIndex + i]);
        }
        return floats;
    }

    public static Vector3f getNormalData(int[] vertices, int vertexIndex) {
        int vertexData = vertices[vertexIndex * STBTTBitmap.STRIDE + IQuadTransformer.NORMAL];
        float x = (float)(vertexData & 0xFF) / 127.0f;
        float y = (float)((vertexData & 0xFF00) >> 8) / 127.0f;
        float z = (float)((vertexData & 0xFF0000) >> 16) / 127.0f;
        return new Vector3f(x, y, z);
    }

    public static int[] packUV(float u, float v) {
        int[] quadData = new int[]{Float.floatToRawIntBits(u), Float.floatToRawIntBits(v)};
        return quadData;
    }

    private static int[] getColorABGR(int[] vertices, int vertexIndex) {
        int color = vertices[STBTTBitmap.STRIDE * vertexIndex + IQuadTransformer.COLOR];
        int[] abgr = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return abgr;
    }

    private static int[] multiplyColor(int[] abgr1, int[] abgr2) {
        return new int[]{abgr1[0] * abgr2[0] / 255, abgr1[1] * abgr2[1] / 255, abgr1[2] * abgr2[2] / 255, abgr1[3] * abgr2[3] / 255};
    }

    public static void multiplyColor(int[] vertices, int vertexIndex, int rgbBlockColor) {
        int[] colorABGR = RenderUtil.getColorABGR(vertices, vertexIndex);
        int[] blockColorABGR = new int[4];
        blockColorABGR[0] = 0xFF | rgbBlockColor >> 24 & 0xFF;
        blockColorABGR[3] = rgbBlockColor >> 16 & 0xFF;
        blockColorABGR[2] = rgbBlockColor >> 8 & 0xFF;
        blockColorABGR[1] = rgbBlockColor & 0xFF;
        int[] multipliedColor = RenderUtil.multiplyColor(colorABGR, blockColorABGR);
        RenderUtil.putColorABGR(vertices, vertexIndex, multipliedColor);
    }

    public static void putColorABGR(int[] vertices, int vertexIndex, int[] abgr) {
        int offset = vertexIndex * STBTTBitmap.STRIDE + IQuadTransformer.COLOR;
        vertices[offset] = abgr[0] << 24 | abgr[1] << 16 | abgr[2] << 8 | abgr[3];
    }

    public static void putColorARGB(int[] vertices, int vertexIndex, int argb) {
        int[] blockColorABGR = new int[4];
        blockColorABGR[0] = 0xFF | argb >> 24 & 0xFF;
        blockColorABGR[3] = argb >> 16 & 0xFF;
        blockColorABGR[2] = argb >> 8 & 0xFF;
        blockColorABGR[1] = argb & 0xFF;
        int offset = vertexIndex * STBTTBitmap.STRIDE + IQuadTransformer.COLOR;
        vertices[offset] = blockColorABGR[0] << 24 | blockColorABGR[1] << 16 | blockColorABGR[2] << 8 | blockColorABGR[3];
    }

    public static float getRed(int color) {
        return (float)FastColor.ARGB32.red((int)color) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)FastColor.ARGB32.green((int)color) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)FastColor.ARGB32.blue((int)color) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
    }
}

