/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core;

import com.benbenlaw.core.config.DimensionConfig;
import com.benbenlaw.core.config.ModpackConfig;
import com.benbenlaw.core.config.StartupConfig;
import com.benbenlaw.core.event.ModpackCrashInformation;
import com.benbenlaw.core.item.CoreItems;
import com.benbenlaw.core.loot.condition.CoreLootModifierCondition;
import com.benbenlaw.core.loot.modifier.CoreLootModifiers;
import com.benbenlaw.core.network.CoreNetworking;
import com.benbenlaw.core.recipe.CoreRecipeConditions;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.slf4j.Logger;

@Mod(value="bblcore")
public class Core {
    public static final String MOD_ID = "bblcore";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Core(IEventBus eventBus, ModContainer modContainer) {
        CoreItems.ITEMS.register(eventBus);
        CoreRecipeConditions.CONDITIONALS.register(eventBus);
        CoreLootModifierCondition.LOOT_CONDITION_TYPES.register(eventBus);
        CoreLootModifiers.LOOT_MODIFIER_SERIALIZERS.register(eventBus);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)StartupConfig.SPEC, "bbl/core/startup.toml");
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)ModpackConfig.SPEC, "bbl/core/modpack.toml");
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)DimensionConfig.SPEC, "bbl/core/dimensions.toml");
        ModpackCrashInformation.register();
        eventBus.addListener(this::addItemToCreativeTab);
        eventBus.addListener(this::registerNetworking);
    }

    private void addItemToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept((ItemLike)CoreItems.UPGRADE_BASE.get());
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public void registerNetworking(RegisterPayloadHandlersEvent event) {
        CoreNetworking.registerNetworking(event);
    }
}

