/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyncableBlock
extends BaseEntityBlock {
    public static final BooleanProperty RUNNING = BooleanProperty.create((String)"running");
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;

    protected SyncableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)RUNNING, (Comparable)Boolean.valueOf(true))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected abstract MapCodec<? extends BaseEntityBlock> codec();

    protected void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!level.isClientSide()) {
            boolean powered = level.hasNeighborSignal(pos);
            if (powered && ((Boolean)state.getValue((Property)RUNNING)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)RUNNING, (Comparable)Boolean.valueOf(false)), 3);
            } else if (!powered && !((Boolean)state.getValue((Property)RUNNING)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)RUNNING, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getNearestLookingDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)direction)).setValue((Property)RUNNING, (Comparable)Boolean.valueOf(true));
    }

    @NotNull
    public BlockState rotate(BlockState blockState, @NotNull LevelAccessor level, @NotNull BlockPos blockPos, Rotation direction) {
        return (BlockState)blockState.setValue(FACING, (Comparable)direction.rotate((Direction)blockState.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RUNNING, FACING});
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return null;
    }
}

