/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.entity.handler.fluid;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import java.util.function.BiPredicate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class InputFluidHandler
extends FluidStacksResourceHandler {
    private final BiPredicate<Integer, FluidStack> canInput;
    private final SyncableBlockEntity blockEntity;
    private boolean internalMode = false;

    public InputFluidHandler(SyncableBlockEntity blockEntity, int size, int capacity, BiPredicate<Integer, FluidStack> canInput) {
        super(size, capacity);
        this.blockEntity = blockEntity;
        this.canInput = canInput;
    }

    public boolean isValid(int index, FluidResource resource) {
        if (this.internalMode) {
            return super.isValid(index, (Resource)resource);
        }
        FluidStack stack = resource.toStack(1);
        return this.canInput.test(index, stack) && super.isValid(index, (Resource)resource);
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (resource.isEmpty()) {
            return 0;
        }
        FluidStack stack = resource.toStack(amount);
        if (!this.internalMode && !this.canInput.test(index, stack)) {
            return 0;
        }
        int inserted = super.insert(index, (Resource)resource, amount, transaction);
        if (inserted > 0) {
            this.onContentsChanged(index, this.getStackFrom(resource, inserted));
        }
        return inserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int extractInternal(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (resource.isEmpty()) {
            return 0;
        }
        this.internalMode = true;
        try {
            int extracted = super.extract(index, (Resource)resource, amount, transaction);
            if (extracted > 0) {
                this.onContentsChanged(index, this.getStackFrom(resource, extracted));
            }
            int n = extracted;
            return n;
        }
        finally {
            this.internalMode = false;
        }
    }

    protected void onContentsChanged(int index, FluidStack previousContents) {
        this.blockEntity.setChanged();
        this.blockEntity.sync();
    }
}

