/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.entity.handler.fluid;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import java.util.function.Predicate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class OutputFluidHandler
extends FluidStacksResourceHandler {
    private final Predicate<Integer> canOutput;
    private final SyncableBlockEntity blockEntity;
    private boolean internalMode = false;

    public OutputFluidHandler(SyncableBlockEntity blockEntity, int size, int capacity, Predicate<Integer> canOutput) {
        super(size, capacity);
        this.blockEntity = blockEntity;
        this.canOutput = canOutput;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (!this.internalMode && !this.canOutput.test(index)) {
            return 0;
        }
        int extracted = super.extract(index, (Resource)resource, amount, transaction);
        if (extracted > 0) {
            this.onContentsChanged(index, this.getStackFrom(resource, extracted));
        }
        return extracted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertInternal(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (resource.isEmpty()) {
            return 0;
        }
        this.internalMode = true;
        try {
            int inserted = super.insert(index, (Resource)resource, amount, transaction);
            if (inserted > 0) {
                this.onContentsChanged(index, this.getStackFrom(resource, inserted));
            }
            int n = inserted;
            return n;
        }
        finally {
            this.internalMode = false;
        }
    }

    protected void onContentsChanged(int index, FluidStack previousContents) {
        this.blockEntity.setChanged();
        this.blockEntity.sync();
    }
}

