/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.entity.handler.item;

import com.benbenlaw.core.block.entity.handler.item.InputItemHandler;
import com.benbenlaw.core.block.entity.handler.item.OutputItemHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class CombinedItemHandler
implements ResourceHandler<ItemResource> {
    private final InputItemHandler inputHandler;
    private final OutputItemHandler outputHandler;

    public CombinedItemHandler(InputItemHandler inputHandler, OutputItemHandler outputHandler) {
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    public int size() {
        return this.inputHandler.size() + this.outputHandler.size();
    }

    public ItemResource getResource(int index) {
        int inputSlots = this.inputHandler.size();
        if (index < inputSlots) {
            return (ItemResource)this.inputHandler.getResource(index);
        }
        return (ItemResource)this.outputHandler.getResource(index - inputSlots);
    }

    public long getAmountAsLong(int index) {
        int inputSlots = this.inputHandler.size();
        if (index < inputSlots) {
            return this.inputHandler.getAmountAsLong(index);
        }
        return this.outputHandler.getAmountAsLong(index - inputSlots);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        int inputSlots = this.inputHandler.size();
        if (index < inputSlots) {
            return this.inputHandler.getCapacityAsLong(index, (Resource)resource);
        }
        return this.outputHandler.getCapacityAsLong(index - inputSlots, (Resource)resource);
    }

    public boolean isValid(int index, ItemResource resource) {
        int inputSlots = this.inputHandler.size();
        if (index < inputSlots) {
            return this.inputHandler.isValid(index, resource);
        }
        return this.outputHandler.isValid(index - inputSlots, resource);
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        int inputSlots = this.inputHandler.size();
        if (index < inputSlots) {
            return this.inputHandler.insert(index, resource, amount, transaction);
        }
        return 0;
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        int inputSlots = this.inputHandler.size();
        if (index < inputSlots) {
            return 0;
        }
        return this.outputHandler.extract(index - inputSlots, resource, amount, transaction);
    }
}

