/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.entity.handler.item;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;

public class FilterItemHandler
extends ItemStacksResourceHandler {
    private final SyncableBlockEntity blockEntity;

    public FilterItemHandler(SyncableBlockEntity blockEntity, int size) {
        super(size);
        this.blockEntity = blockEntity;
    }

    public boolean isBlockItem(ItemResource resource) {
        if (resource == null || resource.getItem() == null) {
            return false;
        }
        return resource.getItem() instanceof BlockItem;
    }

    public Block getBlockFromItem(ItemResource resource) {
        if (!this.isBlockItem(resource)) {
            return null;
        }
        return ((BlockItem)resource.getItem()).getBlock();
    }

    public boolean matchesBlockState(ItemResource resource, BlockState blockState) {
        Block blockFromItem = this.getBlockFromItem(resource);
        if (blockFromItem == null) {
            return false;
        }
        return blockFromItem == blockState.getBlock();
    }

    public boolean matchesBlockState(BlockState blockState, boolean whitelist) {
        boolean hasAnyFilter = false;
        for (int i = 0; i < this.size(); ++i) {
            ItemResource resource = (ItemResource)this.getResource(i);
            hasAnyFilter = true;
            if (!this.matchesBlockState(resource, blockState)) continue;
            return whitelist;
        }
        return !hasAnyFilter || !whitelist;
    }

    public boolean matchesItem(ItemResource resource, ItemStack stack) {
        if (resource == null || stack == null) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)resource.toStack(), (ItemStack)stack);
    }

    public boolean matchesItem(ItemStack stack, boolean whitelist) {
        boolean hasAnyFilter = false;
        for (int i = 0; i < this.size(); ++i) {
            ItemResource resource = (ItemResource)this.getResource(i);
            hasAnyFilter = true;
            if (!this.matchesItem(resource, stack)) continue;
            return whitelist;
        }
        return !hasAnyFilter || !whitelist;
    }

    protected void onContentsChanged(int index, ItemStack previousContents) {
        this.blockEntity.setChanged();
        this.blockEntity.sync();
    }
}

