/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.entity.handler.item;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import java.util.function.BiPredicate;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class InputItemHandler
extends ItemStacksResourceHandler {
    private final BiPredicate<Integer, ItemStack> canInsert;
    private final SyncableBlockEntity blockEntity;
    private boolean internalMode = false;

    public InputItemHandler(SyncableBlockEntity blockEntity, int size, BiPredicate<Integer, ItemStack> canInsert) {
        super(size);
        this.canInsert = canInsert;
        this.blockEntity = blockEntity;
    }

    public boolean isValid(int index, ItemResource resource) {
        ItemStack stack = resource.toStack(1);
        if (this.internalMode) {
            return super.isValid(index, (Resource)resource);
        }
        return this.canInsert.test(index, stack) && super.isValid(index, (Resource)resource);
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (resource.isEmpty()) {
            return 0;
        }
        ItemStack stack = resource.toStack(amount);
        return this.canInsert.test(index, stack) ? super.insert(index, (Resource)resource, amount, transaction) : 0;
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractInternal(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (resource.isEmpty()) {
            return;
        }
        this.internalMode = true;
        try {
            super.extract(index, (Resource)resource, amount, transaction);
        }
        finally {
            this.internalMode = false;
        }
    }

    protected void onContentsChanged(int index, ItemStack previousContents) {
        this.blockEntity.setChanged();
        this.blockEntity.sync();
    }
}

