/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.entity.handler.item;

import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class OutputItemHandler
extends ItemStacksResourceHandler {
    private final Predicate<Integer> canExtract;
    private final SyncableBlockEntity blockEntity;
    private boolean internalMode = false;

    public OutputItemHandler(SyncableBlockEntity blockEntity, int size, Predicate<Integer> canExtract) {
        super(size);
        this.canExtract = canExtract;
        this.blockEntity = blockEntity;
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (this.internalMode) {
            return super.insert(index, (Resource)resource, amount, transaction);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertInternal(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (resource.isEmpty()) {
            return;
        }
        this.internalMode = true;
        try {
            super.insert(index, (Resource)resource, amount, transaction);
        }
        finally {
            this.internalMode = false;
        }
    }

    public boolean isValid(int index, ItemResource resource) {
        return this.internalMode;
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        if (resource.isEmpty() || !this.canExtract.test(index)) {
            return 0;
        }
        return super.extract(index, (Resource)resource, amount, transaction);
    }

    protected void onContentsChanged(int index, ItemStack previousContents) {
        this.blockEntity.setChanged();
        this.blockEntity.sync();
    }
}

