/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.command;

import com.benbenlaw.core.config.ModpackConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class DiscordCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"discord").executes(DiscordCommand::execute));
    }

    private static int execute(CommandContext<CommandSourceStack> command) {
        Entity entity = ((CommandSourceStack)command.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String urlString = (String)ModpackConfig.discordURL.get();
            if (urlString == null || urlString.isBlank()) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.discord_not_set").withStyle(ChatFormatting.RED), false);
                return 1;
            }
            if (!urlString.startsWith("http://") && !urlString.startsWith("https://")) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.discord_invalid_url").withStyle(ChatFormatting.RED), false);
                return 1;
            }
            try {
                URI uri = new URI(urlString);
                player.displayClientMessage((Component)Component.literal((String)urlString).setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(uri)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"chat.bblcore.discord")))), false);
            }
            catch (URISyntaxException e) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.discord_invalid_url").withStyle(ChatFormatting.RED), false);
            }
        }
        return 1;
    }
}

