/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.event;

import com.benbenlaw.core.config.StartupConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="bblcore")
public class BrokenBlockRemoverEvent {
    public static boolean worldSaved = false;
    public static BlockPos positionToFix = new BlockPos(((Integer)StartupConfig.positionToFixX.get()).intValue(), ((Integer)StartupConfig.positionToFixY.get()).intValue(), ((Integer)StartupConfig.positionToFixZ.get()).intValue());

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor accessor = event.getLevel();
        if (((Boolean)StartupConfig.enableSaveTheWorld.get()).booleanValue() && accessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)accessor;
            level.setBlock(positionToFix, Blocks.AIR.defaultBlockState(), 3);
            worldSaved = true;
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && ((Boolean)StartupConfig.enableSaveTheWorld.get()).booleanValue() && worldSaved && player.level().getBlockState(positionToFix).is(Blocks.AIR)) {
            ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)("A problematic block was removed at " + positionToFix.getX() + ", " + positionToFix.getY() + ", " + positionToFix.getZ() + ". Please disable the config and restart the game to prevent any accidental removal of blocks.")));
        }
    }
}

