/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.event;

import com.benbenlaw.core.config.ModpackConfig;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="bblcore")
public class ReturnToPlayerSpawnEvent {
    @SubscribeEvent
    public static void onVoidDamage(LivingDamageEvent.Post event) {
        if (((Boolean)ModpackConfig.enabledVoidProtection.get()).booleanValue()) {
            LivingEntity livingEntity = event.getEntity();
            DamageSource damageSource = event.getSource();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                if (damageSource.is(DamageTypes.FELL_OUT_OF_WORLD)) {
                    ServerPlayer.RespawnConfig respawnConfig = player.getRespawnConfig();
                    assert (respawnConfig != null);
                    BlockPos spawnPos = respawnConfig.respawnData().pos();
                    ResourceKey dimension = respawnConfig.respawnData().dimension();
                    ServerLevel serverLevel = player.level().getServer().getLevel(dimension);
                    assert (serverLevel != null);
                    player.fallDistance = 0.0;
                    TeleportTransition transition = new TeleportTransition(serverLevel, new Vec3((double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ()), Vec3.ZERO, 0.0f, 0.0f, Set.of(), TeleportTransition.DO_NOTHING);
                    player.teleport(transition);
                    player.sendSystemMessage((Component)Component.translatable((String)"chat.bblcore.falling.home"));
                }
            }
        }
    }
}

