/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.event;

import com.benbenlaw.core.config.ModpackConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

@EventBusSubscriber(modid="bblcore", value={Dist.CLIENT})
public class UpdateCheckerEvent {
    private static final String PREFIX = "https://api.curseforge.com";
    private static final String apiKey = "$2a$10$Y64bw4w0RYpXpu9d9bEu7ulQSgP3MzXPm6rfmhEbqhnHf3oa8WOEq";
    private static final Path curseforgeMinecraftInstanceFileLocation = Path.of("minecraftinstance.json", new String[0]);
    private static final int projectID = (Integer)ModpackConfig.projectID.get();

    @SubscribeEvent
    public static void onPlayerLoggingInEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        if (((Boolean)ModpackConfig.updateChecker.get()).booleanValue()) {
            if (Files.exists(curseforgeMinecraftInstanceFileLocation, new LinkOption[0])) {
                try {
                    HttpsURLConnection connection;
                    int currentVersion;
                    BufferedReader reader;
                    block35: {
                        block36: {
                            block33: {
                                block34: {
                                    JsonElement installedModpackElement;
                                    block31: {
                                        block32: {
                                            JsonElement parsed;
                                            block29: {
                                                block30: {
                                                    reader = Files.newBufferedReader(curseforgeMinecraftInstanceFileLocation);
                                                    parsed = JsonParser.parseReader((Reader)reader);
                                                    if (parsed.isJsonObject()) break block29;
                                                    System.out.println("Instance file does not contain a valid JSON object.");
                                                    player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.modpack_invalid_instance").withStyle(ChatFormatting.RED), false);
                                                    if (reader == null) break block30;
                                                    ((Reader)reader).close();
                                                }
                                                return;
                                            }
                                            JsonObject dataObjectInstance = parsed.getAsJsonObject();
                                            installedModpackElement = dataObjectInstance.get("installedModpack");
                                            if (!installedModpackElement.isJsonNull()) break block31;
                                            System.out.println("No modpack is installed (Dev Environment).");
                                            player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.dev_environment").withStyle(ChatFormatting.YELLOW), false);
                                            if (reader == null) break block32;
                                            ((Reader)reader).close();
                                        }
                                        return;
                                    }
                                    JsonObject installedModpack = installedModpackElement.getAsJsonObject();
                                    currentVersion = 0;
                                    if (installedModpack.has("latestFile") && installedModpack.getAsJsonObject("latestFile").has("id")) {
                                        currentVersion = installedModpack.getAsJsonObject("latestFile").get("id").getAsInt();
                                        System.out.println("Installed File ID from instance: " + currentVersion);
                                        break block33;
                                    }
                                    System.out.println("Could not find latestFile.id in instance file.");
                                    player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.modpack_no_version").withStyle(ChatFormatting.RED), false);
                                    if (reader == null) break block34;
                                    ((Reader)reader).close();
                                }
                                return;
                            }
                            connection = (HttpsURLConnection)new URL("https://api.curseforge.com/v1/mods/" + projectID).openConnection();
                            connection.addRequestProperty("x-api-key", apiKey);
                            connection.setRequestMethod("GET");
                            if (connection.getResponseCode() == 200) break block35;
                            System.out.println("Unable to establish connection to API! Code " + connection.getResponseCode());
                            if (connection.getResponseCode() == 403) {
                                System.out.println("(Are you sure the key is valid?)");
                            }
                            if (reader == null) break block36;
                            ((Reader)reader).close();
                        }
                        return;
                    }
                    try {
                        try {
                            String inputLine;
                            StringBuilder response = new StringBuilder();
                            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                            while ((inputLine = in.readLine()) != null) {
                                response.append(inputLine);
                            }
                            in.close();
                            JsonObject jsonObject = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                            JsonObject dataObject = jsonObject.getAsJsonObject("data");
                            JsonArray latestFilesIndexes = dataObject.getAsJsonArray("latestFilesIndexes");
                            String modpackName = dataObject.get("name").getAsString();
                            URI uri = new URI(dataObject.getAsJsonObject("links").get("websiteUrl").getAsString());
                            int latestFileId = 0;
                            if (latestFilesIndexes != null && !latestFilesIndexes.isEmpty()) {
                                JsonObject firstEntry = latestFilesIndexes.get(0).getAsJsonObject();
                                if (firstEntry.has("fileId")) {
                                    latestFileId = firstEntry.get("fileId").getAsInt();
                                    System.out.println("Latest file ID from API: " + latestFileId);
                                } else {
                                    System.out.println("fileId not found in the first entry.");
                                }
                            } else {
                                System.out.println("latestFilesIndexes is missing or empty.");
                            }
                            if (currentVersion == 0) {
                                player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.modpack_no_version").withStyle(ChatFormatting.RED), false);
                            } else if (currentVersion < latestFileId) {
                                player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.modpack_update", (Object[])new Object[]{modpackName}).setStyle(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(uri)).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"chat.bblcore.modpack_website"))).withColor(ChatFormatting.BLUE)), false);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.modpack_up_to_date").withStyle(ChatFormatting.GREEN), false);
                            }
                        }
                        catch (IOException e) {
                            System.out.println("Error while connecting to the API: " + e.getMessage());
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                }
                catch (IOException e) {
                    System.out.println("Error reading the instance file: " + e.getMessage());
                    player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.modpack_instance_error").withStyle(ChatFormatting.RED), false);
                }
            } else {
                System.out.println("CurseForge instance file not found.");
                player.displayClientMessage((Component)Component.translatable((String)"chat.bblcore.modpack_no_instance").withStyle(ChatFormatting.RED), false);
            }
        }
    }
}

