/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.screen.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidStacksResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;

public class FluidRenderingUtils {
    public static void renderFluid(GuiGraphics guiGraphics, FluidStacksResourceHandler handler, int slot, int screenX, int screenY, int tankTopX, int tankTopY, int tankHeight, int tankWidth, int mouseX, int mouseY) {
        FluidStack fluidStack = FluidUtil.getStack((ResourceHandler)handler, (int)slot);
        int capacity = handler.getCapacityAsInt(slot, (Resource)FluidResource.of((FluidStack)fluidStack));
        int tankX = screenX + tankTopX;
        int tankY = screenY + tankTopY;
        if (!fluidStack.isEmpty()) {
            int displayLevel = (int)((float)fluidStack.getAmount() / (float)capacity * (float)tankHeight);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation texture = renderProperties.getStillTexture(fluidStack);
            AtlasManager atlas = Minecraft.getInstance().getAtlasManager();
            TextureAtlasSprite still = atlas.getAtlasOrThrow(ResourceLocation.withDefaultNamespace((String)"blocks")).getSprite(texture);
            FluidRenderingUtils.renderTiledSprite(guiGraphics, still, renderProperties.getTintColor(fluidStack), tankX, tankY + tankHeight - displayLevel, displayLevel, tankWidth);
        }
        if (mouseX >= tankX && mouseX < tankX + tankWidth && mouseY >= tankY && mouseY < tankY + tankHeight) {
            ArrayList<Object> lines = new ArrayList<Object>();
            if (fluidStack.isEmpty()) {
                lines.add(Component.literal((String)"Empty"));
            } else {
                lines.add(fluidStack.getHoverName());
                lines.add(Component.literal((String)String.format("%d / %d mB", fluidStack.getAmount(), capacity)));
            }
            List<ClientTooltipComponent> tooltipComponents = lines.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList();
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltipComponents, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
        }
    }

    public static void renderTiledSprite(GuiGraphics guiGraphics, TextureAtlasSprite sprite, int color, int x, int y, int height, int width) {
        int renderHeight;
        int spriteHeight = sprite.contents().height();
        int startY = y;
        int textureWidth = (int)((float)sprite.contents().width() / (sprite.getU1() - sprite.getU0()));
        int textureHeight = (int)((float)sprite.contents().height() / (sprite.getV1() - sprite.getV0()));
        do {
            renderHeight = Math.min(spriteHeight, height);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, sprite.atlasLocation(), x, startY, (float)textureWidth * sprite.getU0(), (float)textureHeight * sprite.getV0(), width, renderHeight, textureWidth, textureHeight, color);
            startY += renderHeight;
        } while ((height -= renderHeight) > 0);
    }
}

