/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.screen.util.button;

import com.benbenlaw.core.Core;
import com.benbenlaw.core.block.entity.WhitelistBlockEntity;
import com.benbenlaw.core.network.packets.SyncWhitelistMode;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.jetbrains.annotations.NotNull;

public class WhitelistButton
extends Button {
    private boolean whitelist;

    public WhitelistButton(int x, int y, int width, int height, boolean initial, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.whitelist = initial;
        this.height = 18;
        this.width = 18;
    }

    public void toggle() {
        this.whitelist = !this.whitelist;
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean hovered = this.isHovered();
        ResourceLocation currentTexture = this.whitelist ? (hovered ? Core.rl("whitelist_button/whitelist_hover") : Core.rl("whitelist_button/whitelist")) : (hovered ? Core.rl("whitelist_button/blacklist_hover") : Core.rl("whitelist_button/blacklist"));
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, currentTexture, this.getX(), this.getY(), this.width, this.height);
        if (hovered) {
            MutableComponent modeText = Component.translatable((String)(this.whitelist ? "tooltip.bblcore.whitelist_button.whitelist" : "tooltip.bblcore.whitelist_button.blacklist")).withStyle(this.whitelist ? ChatFormatting.GREEN : ChatFormatting.RED);
            MutableComponent tooltip = Component.translatable((String)"tooltip.bblcore.whitelist_button.mode", (Object[])new Object[]{modeText});
            List<ClientTooltipComponent> tooltipComponents = List.of(ClientTooltipComponent.create((FormattedCharSequence)tooltip.getVisualOrderText()));
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltipComponents, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
        }
    }

    public static WhitelistButton create(int x, int y, int width, int height, BlockEntity blockEntity) {
        if (blockEntity instanceof WhitelistBlockEntity) {
            WhitelistBlockEntity whitelistBlockEntity = (WhitelistBlockEntity)blockEntity;
            boolean initialMode = whitelistBlockEntity.isWhitelist();
            return new WhitelistButton(x, y, width, height, initialMode, button -> {
                WhitelistButton whitelistButton = (WhitelistButton)button;
                whitelistButton.toggle();
                boolean newMode = !whitelistBlockEntity.isWhitelist();
                whitelistBlockEntity.setWhitelist(newMode);
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncWhitelistMode(blockEntity.getBlockPos(), newMode), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
        }
        Core.LOGGER.error("Attempted to create WhitelistButton for a BlockEntity that does not implement WhitelistBlockEntity: " + String.valueOf(blockEntity));
        return null;
    }
}

