/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.tag;

import com.benbenlaw.core.tag.MaterialType;

public enum ResourceMaterial {
    COAL("coal"),
    DIAMOND("diamond"),
    EMERALD("emerald"),
    LAPIS("lapis"),
    QUARTZ("quartz"),
    REDSTONE("redstone"),
    NETHERITE("netherite"),
    COPPER("copper"),
    GOLD("gold"),
    IRON("iron"),
    TIN("tin"),
    LEAD("lead"),
    SILVER("silver"),
    ZINC("zinc"),
    ALUMINUM("aluminum"),
    NICKEL("nickel"),
    PLATINUM("platinum"),
    OSMIUM("osmium"),
    URANIUM("uranium"),
    IRIDIUM("iridium"),
    RUBY("ruby"),
    SAPPHIRE("sapphire"),
    PERIDOT("peridot"),
    BRONZE("bronze"),
    BRASS("brass"),
    STEEL("steel"),
    ELECTRUM("electrum"),
    INVAR("invar"),
    CONSTANTAN("constantan"),
    SIGNALUM("signalum"),
    LUMIUM("lumium"),
    ENDERIUM("enderium"),
    CONDUCTIVE_ALLOY("conductive_alloy"),
    ENERGETIC_ALLOY("energetic_alloy"),
    VIBRANT_ALLOY("vibrant_alloy"),
    PULSATING_ALLOY("pulsating_alloy"),
    SOULARIUM("soularium"),
    DARK_STEEL("dark_steel"),
    END_STEEL("end_steel"),
    REDSTONE_ALLOY("redstone_alloy"),
    COPPER_ALLOY("copper_alloy");

    private final String name;

    private ResourceMaterial(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTag(MaterialType type) {
        return "c:" + String.valueOf((Object)type) + "/" + this.name;
    }

    public String getNuggetTag() {
        return this.getTag(MaterialType.NUGGETS);
    }

    public String getIngotTag() {
        return this.getTag(MaterialType.INGOTS);
    }

    public String getStorageBlockTag() {
        return this.getTag(MaterialType.STORAGE_BLOCKS);
    }

    public String getOreTag() {
        return this.getTag(MaterialType.ORES);
    }

    public String getRawMaterialTag() {
        return this.getTag(MaterialType.RAW_MATERIALS);
    }

    public String getRawStorageBlockTag() {
        return this.getTag(MaterialType.RAW_STORAGE_BLOCKS);
    }

    public String getPlateTag() {
        return this.getTag(MaterialType.PLATES);
    }

    public String getDustTag() {
        return this.getTag(MaterialType.DUSTS);
    }

    public String getGearTag() {
        return this.getTag(MaterialType.GEARS);
    }

    public String getRodTag() {
        return this.getTag(MaterialType.RODS);
    }

    public String getGemTag() {
        return this.getTag(MaterialType.GEMS);
    }

    public String getWireTag() {
        return this.getTag(MaterialType.WIRES);
    }
}

