/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone;

import com.mojang.logging.LogUtils;
import com.nouho.soulgravestone.Config;
import com.nouho.soulgravestone.events.DeathEvents;
import com.nouho.soulgravestone.events.RespawnEvents;
import com.nouho.soulgravestone.gravestone.GravestoneBlock;
import com.nouho.soulgravestone.gravestone.GravestoneBlockEntity;
import com.nouho.soulgravestone.soulshape.SoulShapeEffect;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="soulgravestone")
public class SoulGravestone {
    public static final String MODID = "soulgravestone";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"soulgravestone");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"soulgravestone");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"soulgravestone");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"soulgravestone");
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"soulgravestone");
    public static final DeferredHolder<MobEffect, MobEffect> SOUL_SHAPE_EFFECT = EFFECTS.register("soul_shape", () -> new SoulShapeEffect());
    public static final DeferredBlock<GravestoneBlock> GRAVESTONE_BLOCK = BLOCKS.register("gravestone", () -> new GravestoneBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(2.0f, 3600000.0f)));
    public static final DeferredItem<BlockItem> GRAVESTONE_BLOCK_ITEM = ITEMS.registerSimpleBlockItem("gravestone", GRAVESTONE_BLOCK);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<GravestoneBlockEntity>> GRAVESTONE_BLOCK_ENTITY = BLOCK_ENTITIES.register("gravestone", () -> BlockEntityType.Builder.of(GravestoneBlockEntity::new, (Block[])new Block[]{(Block)GRAVESTONE_BLOCK.get()}).build(null));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GRAVESTONE_TAB = CREATIVE_MODE_TABS.register("gravestone_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.soulgravestone")).icon(() -> ((BlockItem)GRAVESTONE_BLOCK_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> output.accept((ItemLike)GRAVESTONE_BLOCK_ITEM.get())).build());
    private static final Map<UUID, BlockPos> lastGravestonePositions = new HashMap<UUID, BlockPos>();
    private static final Map<UUID, Level> lastGravestoneLevels = new HashMap<UUID, Level>();

    public SoulGravestone(IEventBus modEventBus, ModContainer modContainer) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        EFFECTS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)new DeathEvents());
        NeoForge.EVENT_BUS.register((Object)new RespawnEvents());
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
    }

    public static void recordGravestonePosition(Player player, BlockPos pos, Level level) {
        lastGravestonePositions.put(player.getUUID(), pos);
        lastGravestoneLevels.put(player.getUUID(), level);
    }

    public static BlockPos getLastGravestonePos(Player player) {
        return lastGravestonePositions.get(player.getUUID());
    }

    public static Level getLastGravestoneLevel(Player player) {
        return lastGravestoneLevels.get(player.getUUID());
    }

    public static void clearGravestonePosition(Player player) {
        lastGravestonePositions.remove(player.getUUID());
        lastGravestoneLevels.remove(player.getUUID());
    }
}

