/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.nouho.soulgravestone.SoulGravestone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(modid="soulgravestone", value={Dist.CLIENT})
public class SoulShapeScreenOverlay {
    private static final ResourceLocation VIGNETTE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/vignette.png");

    @SubscribeEvent
    public static void onRenderGuiPost(RenderGuiEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.getCameraType().isFirstPerson() && minecraft.player != null && minecraft.player.hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT)) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int screenWidth = minecraft.getWindow().getGuiScaledWidth();
            int screenHeight = minecraft.getWindow().getGuiScaledHeight();
            SoulShapeScreenOverlay.renderVignette(guiGraphics, screenWidth, screenHeight);
        }
    }

    private static void renderVignette(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        guiGraphics.setColor(0.3f, 0.5f, 0.8f, 0.6f);
        guiGraphics.blit(VIGNETTE_LOCATION, 0, 0, -90, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }
}

