/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.events;

import com.nouho.soulgravestone.Config;
import com.nouho.soulgravestone.SoulGravestone;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class RespawnEvents {
    private static final ResourceLocation SOUL_SHAPE_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"soulgravestone", (String)"soul_shape_speed");

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (!event.isEndConquered()) {
            player.addEffect(new MobEffectInstance(SoulGravestone.SOUL_SHAPE_EFFECT, Config.soulShapeDurationTicks, 0, false, false, true));
            BlockPos gravestonePos = SoulGravestone.getLastGravestonePos(player);
            Level gravestoneLevel = SoulGravestone.getLastGravestoneLevel(player);
            if (gravestonePos != null && gravestoneLevel != null) {
                ItemStack lodestoneCompass = new ItemStack((ItemLike)Items.COMPASS);
                GlobalPos globalPos = GlobalPos.of((ResourceKey)gravestoneLevel.dimension(), (BlockPos)gravestonePos);
                lodestoneCompass.set(DataComponents.LODESTONE_TRACKER, (Object)new LodestoneTracker(Optional.of(globalPos), false));
                if (!player.getInventory().add(lodestoneCompass)) {
                    player.drop(lodestoneCompass, false);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (player.hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT)) {
            AttributeInstance attr;
            if (!player.isInvisible()) {
                player.setInvisible(true);
            }
            if (Config.soulShapeSpeedBonus > 0.0 && (attr = player.getAttribute(Attributes.MOVEMENT_SPEED)) != null && attr.getModifier(SOUL_SHAPE_SPEED_ID) == null) {
                attr.addTransientModifier(new AttributeModifier(SOUL_SHAPE_SPEED_ID, Config.soulShapeSpeedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
        } else {
            AttributeInstance attr;
            if (player.isInvisible()) {
                player.setInvisible(false);
            }
            if ((attr = player.getAttribute(Attributes.MOVEMENT_SPEED)) != null && attr.getModifier(SOUL_SHAPE_SPEED_ID) != null) {
                attr.removeModifier(SOUL_SHAPE_SPEED_ID);
            }
        }
    }

    @SubscribeEvent
    public void onMobTarget(LivingChangeTargetEvent event) {
        Player player;
        LivingEntity newTarget = event.getNewAboutToBeSetTarget();
        if (newTarget instanceof Player && (player = (Player)newTarget).hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onContainerOpen(PlayerInteractEvent.RightClickBlock event) {
        RandomizableContainerBlockEntity randomizableContainer;
        BlockEntity blockEntity;
        Player player = event.getEntity();
        if (!player.hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT)) {
            return;
        }
        Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
        if ((block instanceof ChestBlock || block instanceof BarrelBlock || block instanceof ShulkerBoxBlock) && (blockEntity = event.getLevel().getBlockEntity(event.getPos())) instanceof RandomizableContainerBlockEntity && (randomizableContainer = (RandomizableContainerBlockEntity)blockEntity).getLootTable() != null) {
            event.setCanceled(true);
            if (!player.level().isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a77You cannot access loot chests while in Soul Shape"), true);
            }
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT)) {
            return;
        }
        if (Config.soulShapePreventBlockBreaking) {
            event.setCanceled(true);
            if (!player.level().isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a77You cannot break blocks while in Soul Shape"), true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player;
        Player player2 = event.getPlayer();
        if (player2 instanceof Player && (player = player2).hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT) && Config.soulShapeRemoveOnBlockBreak) {
            player.removeEffect(SoulGravestone.SOUL_SHAPE_EFFECT);
        }
    }

    @SubscribeEvent
    public void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        Player attacker;
        boolean attackerHasSoulShape;
        LivingEntity entity = event.getEntity();
        DamageSource damageSource = event.getSource();
        boolean victimHasSoulShape = entity.hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT);
        Entity entity2 = damageSource.getEntity();
        boolean bl = attackerHasSoulShape = entity2 instanceof Player && (attacker = (Player)entity2).hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT);
        if (!victimHasSoulShape && !attackerHasSoulShape) {
            return;
        }
        if (victimHasSoulShape && Config.soulShapeInvincible) {
            event.setCanceled(true);
            return;
        }
        if (attackerHasSoulShape && (entity2 = damageSource.getEntity()) instanceof Player) {
            attacker = (Player)entity2;
            if (Config.soulShapePreventAttacks) {
                event.setCanceled(true);
            } else {
                attacker.removeEffect(SoulGravestone.SOUL_SHAPE_EFFECT);
            }
        }
    }
}

