/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.gravestone;

import com.nouho.soulgravestone.SoulGravestone;
import com.nouho.soulgravestone.gravestone.GravestoneBlockEntity;
import com.nouho.soulgravestone.managers.GravestoneManager;
import com.nouho.soulgravestone.managers.InventoryManager;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GravestoneBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape GRAVESTONE_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)});

    public GravestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return GRAVESTONE_SHAPE;
    }

    public VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return GRAVESTONE_SHAPE;
    }

    public boolean useShapeForLightOcclusion(@Nonnull BlockState state) {
        return true;
    }

    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new GravestoneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        if (level.isClientSide && type == SoulGravestone.GRAVESTONE_BLOCK_ENTITY.get()) {
            return GravestoneBlockEntity::tick;
        }
        return null;
    }

    public void onRemove(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!level.isClientSide && state.getBlock() != newState.getBlock()) {
            GravestoneManager.removeGravestoneNameDisplay(level, pos);
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof GravestoneBlockEntity) {
                GravestoneBlockEntity gravestoneBE = (GravestoneBlockEntity)be;
                for (ItemStack stack : gravestoneBE.getInventory()) {
                    if (stack.isEmpty()) continue;
                    GravestoneBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        if (!level.isClientSide) {
            GravestoneManager.removeGravestoneNameDisplay(level, pos);
            InventoryManager.restoreGravestoneContents(level, pos, player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (level.isClientSide && random.nextInt(3) == 0) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble();
            double z = (double)pos.getZ() + random.nextDouble();
            int face = random.nextInt(5);
            switch (face) {
                case 0: {
                    z = (double)pos.getZ() - 0.2;
                    break;
                }
                case 1: {
                    z = (double)pos.getZ() + 1.2;
                    break;
                }
                case 2: {
                    x = (double)pos.getX() - 0.2;
                    break;
                }
                case 3: {
                    x = (double)pos.getX() + 1.2;
                    break;
                }
                case 5: {
                    y = (double)pos.getY() + 1.2;
                }
            }
            double motionX = ((double)pos.getX() + 0.5 - x) * 0.01;
            double motionY = 0.02 + random.nextDouble() * 0.03;
            double motionZ = ((double)pos.getZ() + 0.5 - z) * 0.01;
            level.addParticle((ParticleOptions)ParticleTypes.SOUL, x, y + 0.2, z, motionX, motionY, motionZ);
        }
    }
}

