/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.gravestone;

import com.nouho.soulgravestone.SoulGravestone;
import com.nouho.soulgravestone.managers.CuriosManager;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;

public class GravestoneBlockEntity
extends BlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)41, (Object)ItemStack.EMPTY);
    private int storedXp = 0;
    private String playerName = "";
    private int soundTicker = 0;
    private int nextSoundInterval = 0;

    public GravestoneBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SoulGravestone.GRAVESTONE_BLOCK_ENTITY.get(), pos, state);
    }

    public void ensureInventorySize(Player player) {
        int requiredSize = GravestoneBlockEntity.calculateRequiredInventorySize(player);
        if (this.inventory.size() < requiredSize) {
            int oldSize = this.inventory.size();
            NonNullList newInventory = NonNullList.withSize((int)requiredSize, (Object)ItemStack.EMPTY);
            for (int i = 0; i < this.inventory.size(); ++i) {
                newInventory.set(i, (Object)((ItemStack)this.inventory.get(i)));
            }
            this.inventory = newInventory;
            SoulGravestone.LOGGER.info("Gravestone inventory resized from " + oldSize + " to " + requiredSize + " slots for player " + player.getName().getString());
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int getStoredXp() {
        return this.storedXp;
    }

    public void setStoredXp(int xp) {
        this.storedXp = xp;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String name) {
        this.playerName = name;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GravestoneBlockEntity blockEntity) {
        if (level.isClientSide) {
            ++blockEntity.soundTicker;
            if (blockEntity.nextSoundInterval == 0) {
                blockEntity.nextSoundInterval = 80 + level.random.nextInt(61);
            }
            if (blockEntity.soundTicker >= blockEntity.nextSoundInterval) {
                float volume = 0.7f + level.random.nextFloat() * 0.3f;
                float pitch = 0.6f + level.random.nextFloat() * 0.4f;
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, volume, pitch, false);
                blockEntity.soundTicker = 0;
                blockEntity.nextSoundInterval = 80 + level.random.nextInt(61);
            }
        }
    }

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        int savedSize;
        super.loadAdditional(tag, provider);
        if (tag.contains("InventorySize") && (savedSize = tag.getInt("InventorySize")) != this.inventory.size()) {
            this.inventory = NonNullList.withSize((int)savedSize, (Object)ItemStack.EMPTY);
        }
        this.inventory.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        this.storedXp = tag.contains("StoredXp") ? tag.getInt("StoredXp") : 0;
        this.playerName = tag.contains("PlayerName") ? tag.getString("PlayerName") : "";
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("InventorySize", this.inventory.size());
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        tag.putInt("StoredXp", this.storedXp);
        tag.putString("PlayerName", this.playerName);
    }

    public static int calculateRequiredInventorySize(Player player) {
        int baseSlots = 41;
        int curiosSlots = 0;
        if (ModList.get().isLoaded("curios")) {
            try {
                curiosSlots = CuriosManager.getTotalCuriosSlots(player);
            }
            catch (Exception e) {
                curiosSlots = 0;
            }
        }
        return baseSlots + curiosSlots;
    }

    public boolean hasEnoughSpaceFor(Player player) {
        int requiredSize = GravestoneBlockEntity.calculateRequiredInventorySize(player);
        return this.inventory.size() >= requiredSize;
    }
}

