/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.managers;

import com.nouho.soulgravestone.SoulGravestone;
import com.nouho.soulgravestone.gravestone.GravestoneBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosManager {
    public static List<ItemStack> capturePreDeathCurios(Player player) {
        ArrayList<ItemStack> preDeathCurios = new ArrayList<ItemStack>();
        try {
            Optional curiosInventoryOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (curiosInventoryOpt.isPresent()) {
                ItemStack stack;
                int i;
                ICurioStacksHandler curiosStacksHandler;
                ICuriosItemHandler curiosInventory = (ICuriosItemHandler)curiosInventoryOpt.get();
                Map curios = curiosInventory.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    curiosStacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = curiosStacksHandler.getStacks();
                    int size = stackHandler.getSlots();
                    for (i = 0; i < size; ++i) {
                        stack = stackHandler.getStackInSlot(i);
                        preDeathCurios.add(stack.copy());
                    }
                }
                for (Map.Entry entry : curios.entrySet()) {
                    curiosStacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler cosmeticStackHandler = curiosStacksHandler.getCosmeticStacks();
                    int cosmeticSize = cosmeticStackHandler.getSlots();
                    for (i = 0; i < cosmeticSize; ++i) {
                        stack = cosmeticStackHandler.getStackInSlot(i);
                        preDeathCurios.add(stack.copy());
                    }
                }
            }
        }
        catch (Exception e) {
            SoulGravestone.LOGGER.error("[CuriosManager.capturePreDeathCurios] Error capturing pre-death Curios items for player: " + player.getName().getString(), (Throwable)e);
        }
        return preDeathCurios;
    }

    public static void handlePlayerCloneCuriosWithComparison(Player oldPlayer, Player newPlayer, GravestoneBlockEntity gravestoneBE, List<ItemStack> preDeathCuriosItems) {
        if (preDeathCuriosItems == null || preDeathCuriosItems.isEmpty()) {
            return;
        }
        MinecraftServer server = newPlayer.level().getServer();
        if (server != null) {
            CuriosManager.attemptCuriosTransferWithRetry(newPlayer, gravestoneBE, preDeathCuriosItems, server, 0);
        } else {
            try {
                List<ItemStack> currentCurios = CuriosManager.getCurrentCuriosItems(newPlayer);
                CuriosManager.transferLostCuriosToGravestone(preDeathCuriosItems, currentCurios, gravestoneBE);
            }
            catch (Exception e) {
                SoulGravestone.LOGGER.error("[CuriosManager.handlePlayerCloneCuriosWithComparison] Error in fallback (no server) Curios handling for player: " + newPlayer.getName().getString(), (Throwable)e);
            }
        }
    }

    private static void attemptCuriosTransferWithRetry(Player newPlayer, GravestoneBlockEntity gravestoneBE, List<ItemStack> preDeathCuriosItems, MinecraftServer server, int attemptCount) {
        int maxAttempts = 3;
        int delayTicks = attemptCount == 0 ? 1 : 2;
        server.tell((Runnable)new TickTask(delayTicks, () -> {
            try {
                Optional curiosOpt = CuriosApi.getCuriosInventory((LivingEntity)newPlayer);
                if (curiosOpt.isEmpty() || ((ICuriosItemHandler)curiosOpt.get()).getCurios().isEmpty()) {
                    if (attemptCount < 3) {
                        CuriosManager.attemptCuriosTransferWithRetry(newPlayer, gravestoneBE, preDeathCuriosItems, server, attemptCount + 1);
                    } else {
                        SoulGravestone.LOGGER.error("[CuriosManager.attemptCuriosTransferWithRetry] Failed to initialize Curios inventory after 3 attempts for player: " + newPlayer.getName().getString());
                    }
                    return;
                }
                List<ItemStack> currentCurios = CuriosManager.getCurrentCuriosItems(newPlayer);
                CuriosManager.transferLostCuriosToGravestone(preDeathCuriosItems, currentCurios, gravestoneBE);
            }
            catch (Exception e) {
                SoulGravestone.LOGGER.error("[CuriosManager.attemptCuriosTransferWithRetry] Error during Curios transfer attempt " + (attemptCount + 1) + " for player: " + newPlayer.getName().getString(), (Throwable)e);
            }
        }));
    }

    public static int getTotalCuriosSlots(Player player) {
        int totalSlots = 0;
        try {
            Optional curiosInventoryOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (curiosInventoryOpt.isPresent()) {
                ICuriosItemHandler curiosInventory = (ICuriosItemHandler)curiosInventoryOpt.get();
                Map curios = curiosInventory.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler curiosStacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = curiosStacksHandler.getStacks();
                    int size = stackHandler.getSlots();
                    totalSlots += size;
                    IDynamicStackHandler cosmeticStackHandler = curiosStacksHandler.getCosmeticStacks();
                    int cosmeticSize = cosmeticStackHandler.getSlots();
                    totalSlots += cosmeticSize;
                }
            }
        }
        catch (Exception e) {
            SoulGravestone.LOGGER.error("[CuriosManager.getTotalCuriosSlots] Error getting total Curios slots for player: " + player.getName().getString(), (Throwable)e);
            return 0;
        }
        return totalSlots;
    }

    public static void handlePlayerRetrieveCurios(Player player, GravestoneBlockEntity gravestoneBE) {
        try {
            int slotIndex;
            ICurioStacksHandler curiosStacksHandler;
            Optional curiosInventoryOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (!curiosInventoryOpt.isPresent()) {
                return;
            }
            ICuriosItemHandler curiosInventory = (ICuriosItemHandler)curiosInventoryOpt.get();
            Map curios = curiosInventory.getCurios();
            ArrayList<SlotMapping> slotMappings = new ArrayList<SlotMapping>();
            for (Map.Entry entry : curios.entrySet()) {
                curiosStacksHandler = (ICurioStacksHandler)entry.getValue();
                IDynamicStackHandler stackHandler = curiosStacksHandler.getStacks();
                for (slotIndex = 0; slotIndex < stackHandler.getSlots(); ++slotIndex) {
                    slotMappings.add(new SlotMapping(slotIndex, false, curiosStacksHandler));
                }
            }
            for (Map.Entry entry : curios.entrySet()) {
                curiosStacksHandler = (ICurioStacksHandler)entry.getValue();
                IDynamicStackHandler cosmeticStackHandler = curiosStacksHandler.getCosmeticStacks();
                for (slotIndex = 0; slotIndex < cosmeticStackHandler.getSlots(); ++slotIndex) {
                    slotMappings.add(new SlotMapping(slotIndex, true, curiosStacksHandler));
                }
            }
            for (int gravestoneSlot = 41; gravestoneSlot < gravestoneBE.getInventory().size(); ++gravestoneSlot) {
                ItemStack storedStack = (ItemStack)gravestoneBE.getInventory().get(gravestoneSlot);
                if (storedStack.isEmpty()) continue;
                int targetGlobalIndex = gravestoneSlot - 41;
                if (targetGlobalIndex < slotMappings.size()) {
                    SlotMapping mapping = (SlotMapping)slotMappings.get(targetGlobalIndex);
                    if (mapping.getStackInSlot().isEmpty()) {
                        mapping.setStackInSlot(storedStack.copy());
                        gravestoneBE.getInventory().set(gravestoneSlot, (Object)ItemStack.EMPTY);
                        continue;
                    }
                    if (!player.getInventory().add(storedStack.copy())) {
                        player.drop(storedStack.copy(), false);
                    }
                    gravestoneBE.getInventory().set(gravestoneSlot, (Object)ItemStack.EMPTY);
                    continue;
                }
                if (!player.getInventory().add(storedStack.copy())) {
                    player.drop(storedStack.copy(), false);
                }
                gravestoneBE.getInventory().set(gravestoneSlot, (Object)ItemStack.EMPTY);
            }
        }
        catch (Exception e) {
            SoulGravestone.LOGGER.error("[CuriosManager.handlePlayerRetrieveCurios] Error retrieving Curios items from gravestone for player: " + player.getName().getString(), (Throwable)e);
        }
    }

    private static List<ItemStack> getCurrentCuriosItems(Player player) {
        ArrayList<ItemStack> currentCurios = new ArrayList<ItemStack>();
        try {
            Optional curiosInventoryOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
            if (curiosInventoryOpt.isPresent()) {
                ItemStack stack;
                int i;
                ICurioStacksHandler curiosStacksHandler;
                ICuriosItemHandler curiosInventory = (ICuriosItemHandler)curiosInventoryOpt.get();
                Map curios = curiosInventory.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    curiosStacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = curiosStacksHandler.getStacks();
                    int size = stackHandler.getSlots();
                    for (i = 0; i < size; ++i) {
                        stack = stackHandler.getStackInSlot(i);
                        currentCurios.add(stack.copy());
                    }
                }
                for (Map.Entry entry : curios.entrySet()) {
                    curiosStacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler cosmeticStackHandler = curiosStacksHandler.getCosmeticStacks();
                    int cosmeticSize = cosmeticStackHandler.getSlots();
                    for (i = 0; i < cosmeticSize; ++i) {
                        stack = cosmeticStackHandler.getStackInSlot(i);
                        currentCurios.add(stack.copy());
                    }
                }
            }
        }
        catch (Exception e) {
            SoulGravestone.LOGGER.error("[CuriosManager.getCurrentCuriosItems] Error getting current Curios items for player: " + player.getName().getString(), (Throwable)e);
        }
        return currentCurios;
    }

    private static void transferLostCuriosToGravestone(List<ItemStack> preDeathCurios, List<ItemStack> currentCurios, GravestoneBlockEntity gravestoneBE) {
        for (int slotIndex = 0; slotIndex < preDeathCurios.size(); ++slotIndex) {
            ItemStack currentStack;
            ItemStack preDeathStack = preDeathCurios.get(slotIndex);
            if (preDeathStack.isEmpty()) continue;
            ItemStack itemStack = currentStack = slotIndex < currentCurios.size() ? currentCurios.get(slotIndex) : ItemStack.EMPTY;
            if (ItemStack.matches((ItemStack)preDeathStack, (ItemStack)currentStack)) continue;
            int gravestoneSlot = 41 + slotIndex;
            if (gravestoneSlot < gravestoneBE.getInventory().size()) {
                gravestoneBE.getInventory().set(gravestoneSlot, (Object)preDeathStack.copy());
                continue;
            }
            SoulGravestone.LOGGER.warn("[CuriosManager.transferLostCuriosToGravestone] Gravestone is full, cannot store Curios item at slot " + slotIndex + ". Item may be lost!");
            break;
        }
        gravestoneBE.setChanged();
    }

    private static class SlotMapping {
        final int slotIndex;
        final boolean isCosmetic;
        final ICurioStacksHandler curiosHandler;

        SlotMapping(int slotIndex, boolean isCosmetic, ICurioStacksHandler curiosHandler) {
            this.slotIndex = slotIndex;
            this.isCosmetic = isCosmetic;
            this.curiosHandler = curiosHandler;
        }

        ItemStack getStackInSlot() {
            try {
                if (this.isCosmetic) {
                    return this.curiosHandler.getCosmeticStacks().getStackInSlot(this.slotIndex);
                }
                return this.curiosHandler.getStacks().getStackInSlot(this.slotIndex);
            }
            catch (Exception e) {
                SoulGravestone.LOGGER.error("[CuriosManager.SlotMapping.getStackInSlot] Error getting stack from Curios slot " + this.slotIndex + " (cosmetic: " + this.isCosmetic + ")", (Throwable)e);
                return ItemStack.EMPTY;
            }
        }

        void setStackInSlot(ItemStack stack) {
            try {
                if (this.isCosmetic) {
                    this.curiosHandler.getCosmeticStacks().setStackInSlot(this.slotIndex, stack);
                } else {
                    this.curiosHandler.getStacks().setStackInSlot(this.slotIndex, stack);
                }
            }
            catch (Exception e) {
                SoulGravestone.LOGGER.error("[CuriosManager.SlotMapping.setStackInSlot] Failed to set stack in Curios slot " + this.slotIndex + " (cosmetic: " + this.isCosmetic + "): " + stack.getItem().toString(), (Throwable)e);
            }
        }
    }
}

