/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.managers;

import com.nouho.soulgravestone.Config;
import com.nouho.soulgravestone.SoulGravestone;
import com.nouho.soulgravestone.gravestone.GravestoneBlock;
import com.nouho.soulgravestone.gravestone.GravestoneBlockEntity;
import com.nouho.soulgravestone.managers.InventoryManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class GravestoneManager {
    private static final Map<UUID, BlockPos> lastSafePositions = new HashMap<UUID, BlockPos>();

    public static void updatePlayerSafePosition(Player player) {
        boolean notInVoid;
        if (player.level().isClientSide()) {
            return;
        }
        BlockPos pos = player.blockPosition();
        ServerLevel level = (ServerLevel)player.level();
        BlockState state = level.getBlockState(pos);
        BlockState below = level.getBlockState(pos.below());
        boolean onSolid = below.isSolidRender((BlockGetter)level, pos.below());
        boolean notLiquid = state.getFluidState().isEmpty();
        boolean bl = notInVoid = level.dimension() != Level.END || pos.getY() >= 0;
        if (onSolid && notLiquid && notInVoid) {
            lastSafePositions.put(player.getUUID(), pos);
        }
    }

    public static boolean shouldCreateGravestone(ServerLevel level, BlockPos deathPos) {
        boolean isVoid;
        BlockState state = level.getBlockState(deathPos);
        boolean isLava = state.getFluidState().is((Fluid)Fluids.LAVA);
        boolean bl = isVoid = level.dimension() == Level.END && deathPos.getY() < 0;
        if (isVoid) {
            return Config.gravestoneOnVoidDeath;
        }
        if (isLava) {
            return Config.gravestoneOnLavaDeath;
        }
        return true;
    }

    public static BlockPos findGravestonePosition(Player player, ServerLevel level, BlockPos deathPos) {
        BlockPos lastSafe;
        boolean isVoid;
        BlockPos gravestonePos = deathPos;
        BlockState state = level.getBlockState(deathPos);
        boolean isWater = state.getFluidState().is((Fluid)Fluids.WATER);
        boolean isLava = state.getFluidState().is((Fluid)Fluids.LAVA);
        boolean bl = isVoid = level.dimension() == Level.END && deathPos.getY() < 0;
        if (isVoid) {
            BlockPos lastSafe2;
            if (Config.gravestoneOnVoidDeath && (lastSafe2 = lastSafePositions.get(player.getUUID())) != null && GravestoneManager.isSafeGravestonePos(level, lastSafe2)) {
                gravestonePos = lastSafe2;
            }
        } else if (isLava) {
            if (Config.gravestoneOnLavaDeath) {
                if (!Config.allowGravestoneInLava) {
                    BlockPos lastSafe3 = lastSafePositions.get(player.getUUID());
                    if (lastSafe3 != null && GravestoneManager.isSafeGravestonePos(level, lastSafe3)) {
                        gravestonePos = lastSafe3;
                    }
                } else {
                    BlockPos bottom = GravestoneManager.findBottomOfLiquid(level, deathPos, (Fluid)Fluids.LAVA);
                    if (GravestoneManager.isSafeGravestonePos(level, bottom)) {
                        gravestonePos = bottom;
                    } else {
                        BlockPos safe = lastSafePositions.get(player.getUUID());
                        if (safe != null && GravestoneManager.isSafeGravestonePos(level, safe)) {
                            gravestonePos = safe;
                        }
                    }
                }
            }
        } else if (isWater) {
            if (!Config.allowGravestoneInWater) {
                BlockPos lastSafe4 = lastSafePositions.get(player.getUUID());
                if (lastSafe4 != null && GravestoneManager.isSafeGravestonePos(level, lastSafe4)) {
                    gravestonePos = lastSafe4;
                }
            } else {
                BlockPos bottom = GravestoneManager.findBottomOfLiquid(level, deathPos, (Fluid)Fluids.WATER);
                if (GravestoneManager.isSafeGravestonePos(level, bottom)) {
                    gravestonePos = bottom;
                } else {
                    BlockPos safe = lastSafePositions.get(player.getUUID());
                    if (safe != null && GravestoneManager.isSafeGravestonePos(level, safe)) {
                        gravestonePos = safe;
                    }
                }
            }
        } else if (!GravestoneManager.isSafeGravestonePos(level, deathPos) && (lastSafe = lastSafePositions.get(player.getUUID())) != null && GravestoneManager.isSafeGravestonePos(level, lastSafe)) {
            gravestonePos = lastSafe;
        }
        return gravestonePos;
    }

    public static boolean createGravestone(Player player, ServerLevel level, BlockPos pos) {
        Direction playerFacing = player.getDirection();
        BlockState gravestoneState = (BlockState)((GravestoneBlock)((Object)SoulGravestone.GRAVESTONE_BLOCK.get())).defaultBlockState().setValue((Property)GravestoneBlock.FACING, (Comparable)playerFacing);
        level.setBlockAndUpdate(pos, gravestoneState);
        BlockState placedState = level.getBlockState(pos);
        if (placedState.getBlock() instanceof GravestoneBlock) {
            SoulGravestone.recordGravestonePosition(player, pos, (Level)level);
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof GravestoneBlockEntity) {
                GravestoneBlockEntity gravestoneBE = (GravestoneBlockEntity)be;
                gravestoneBE.setPlayerName(player.getName().getString());
                int xp = InventoryManager.getPlayerTotalXP(player);
                int retainedXp = (int)((double)xp * Config.xpRetainRatio);
                gravestoneBE.setStoredXp(retainedXp);
                GravestoneManager.createGravestoneNameDisplay(level, pos, player.getName().getString());
            }
            return true;
        }
        return false;
    }

    public static void handleGravestoneRetrieval(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof GravestoneBlock && !level.isClientSide && event.getHand() == InteractionHand.MAIN_HAND && !player.isCrouching()) {
            ItemStack heldItem = player.getItemInHand(event.getHand());
            if (!heldItem.isEmpty()) {
                return;
            }
            boolean hadSoulShape = player.hasEffect(SoulGravestone.SOUL_SHAPE_EFFECT);
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (stack.getItem() != Items.COMPASS || !stack.has(DataComponents.LODESTONE_TRACKER)) continue;
                inventory.removeItem(i, stack.getCount());
                SoulGravestone.clearGravestonePosition(player);
                break;
            }
            block.playerWillDestroy(level, pos, state, player);
            level.removeBlock(pos, false);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_EQUIP_LEATHER, SoundSource.PLAYERS, 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
            if (hadSoulShape) {
                player.removeEffect(SoulGravestone.SOUL_SHAPE_EFFECT);
                player.addEffect(new MobEffectInstance(SoulGravestone.SOUL_SHAPE_EFFECT, Config.soulShapeRetrieveDurationTicks, 0, false, false, true));
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static void removeGravestoneNameDisplay(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            try {
                Vec3 center = Vec3.atCenterOf((Vec3i)pos);
                AABB searchArea = new AABB(center.add(-0.6, -4.0, -0.6), center.add(0.6, 1.0, 0.6));
                List armorStands = level.getEntitiesOfClass(ArmorStand.class, searchArea, armorStand -> {
                    if (!armorStand.isInvisible()) {
                        return false;
                    }
                    if (!armorStand.hasCustomName() || !armorStand.isCustomNameVisible()) {
                        return false;
                    }
                    if (!armorStand.isNoGravity()) {
                        return false;
                    }
                    if (!armorStand.isInvulnerable()) {
                        return false;
                    }
                    Component customName = armorStand.getCustomName();
                    return customName != null && customName.getString().endsWith("'s grave");
                });
                for (ArmorStand armorStand2 : armorStands) {
                    armorStand2.discard();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isSafeGravestonePos(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        BlockState below = level.getBlockState(pos.below());
        boolean replaceable = state.isAir() || state.canBeReplaced();
        boolean notLiquid = state.getFluidState().isEmpty();
        boolean solidBelow = below.isSolidRender((BlockGetter)level, pos.below());
        return replaceable && notLiquid && solidBelow;
    }

    private static BlockPos findBottomOfLiquid(ServerLevel level, BlockPos start, Fluid fluidType) {
        BlockState state;
        BlockPos pos = start;
        while (pos.getY() > level.getMinBuildHeight() && (state = level.getBlockState(pos)).getFluidState().is(fluidType)) {
            BlockPos below = pos.below();
            BlockState belowState = level.getBlockState(below);
            if (!belowState.getFluidState().is(fluidType)) {
                return pos;
            }
            pos = below;
        }
        return start;
    }

    private static void createGravestoneNameDisplay(ServerLevel level, BlockPos gravestonePos, String playerName) {
        try {
            ArmorStand nameDisplay = new ArmorStand(EntityType.ARMOR_STAND, (Level)level);
            double x = (double)gravestonePos.getX() + 0.5;
            double y = (double)gravestonePos.getY() - 1.0;
            double z = (double)gravestonePos.getZ() + 0.5;
            nameDisplay.setPos(x, y, z);
            nameDisplay.setInvisible(true);
            nameDisplay.setNoGravity(true);
            nameDisplay.setInvulnerable(true);
            nameDisplay.setNoBasePlate(true);
            nameDisplay.setShowArms(false);
            nameDisplay.setSilent(true);
            nameDisplay.setCustomName((Component)Component.literal((String)(playerName + "'s grave")));
            nameDisplay.setCustomNameVisible(true);
            level.addFreshEntity((Entity)nameDisplay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

