/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.soulshape;

import com.nouho.soulgravestone.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SoulShapeEffect
extends MobEffect {
    private static final Map<UUID, Double> previousX = new HashMap<UUID, Double>();
    private static final Map<UUID, Double> previousZ = new HashMap<UUID, Double>();

    public SoulShapeEffect() {
        super(MobEffectCategory.BENEFICIAL, 8970751);
    }

    public boolean applyEffectTick(@Nonnull LivingEntity entity, int amplifier) {
        if (Config.soulShapeSlowFalling && !entity.onGround() && entity.getDeltaMovement().y < -0.125) {
            entity.setDeltaMovement(entity.getDeltaMovement().x, -0.125, entity.getDeltaMovement().z);
            entity.fallDistance = 0.0f;
        }
        if (!entity.level().isClientSide) {
            if (entity.level().random.nextInt(10) == 0) {
                double entityX = entity.getX();
                double entityY = entity.getY();
                double entityZ = entity.getZ();
                double angle = entity.level().random.nextDouble() * 2.0 * Math.PI;
                double radius = 0.5 + entity.level().random.nextDouble() * 0.2;
                double x = entityX + Math.cos(angle) * radius;
                double y = entityY + entity.level().random.nextDouble() * (double)entity.getBbHeight();
                double z = entityZ + Math.sin(angle) * radius;
                double motionX = (x - entityX) * 0.02;
                double motionY = 0.02 + entity.level().random.nextDouble() * 0.03;
                double motionZ = (z - entityZ) * 0.02;
                ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL, x, y, z, 1, motionX, motionY, motionZ, 0.01);
            }
            if (entity instanceof Player) {
                double deltaZ;
                double deltaX;
                double movementDistance;
                Player player = (Player)entity;
                UUID playerId = player.getUUID();
                double currentX = player.getX();
                double currentZ = player.getZ();
                Double prevX = previousX.get(playerId);
                Double prevZ = previousZ.get(playerId);
                if (prevX != null && prevZ != null && player.onGround() && (movementDistance = Math.sqrt((deltaX = currentX - prevX) * deltaX + (deltaZ = currentZ - prevZ) * deltaZ)) > 0.2) {
                    double speedFactor = movementDistance < 0.25 ? Math.min(movementDistance * 1.2, 1.0) : Math.min(0.3 + (movementDistance - 0.25) * 3.0, 1.0);
                    if (player.level().random.nextDouble() < speedFactor) {
                        double trailX = currentX;
                        double trailZ = currentZ;
                        double trailY = player.getY() + 0.3;
                        double particleMotionY = 0.03 + player.level().random.nextDouble() * 0.04;
                        ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL, trailX += (player.level().random.nextDouble() - 0.5) * 0.3, trailY, trailZ += (player.level().random.nextDouble() - 0.5) * 0.3, 1, 0.05, particleMotionY, 0.05, 0.01);
                    }
                }
                previousX.put(playerId, currentX);
                previousZ.put(playerId, currentZ);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

