/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.events;

import com.nouho.soulgravestone.SoulGravestone;
import com.nouho.soulgravestone.gravestone.GravestoneBlockEntity;
import com.nouho.soulgravestone.managers.CuriosManager;
import com.nouho.soulgravestone.managers.GravestoneManager;
import com.nouho.soulgravestone.managers.InventoryManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class DeathEvents {
    private static final Map<UUID, GravestoneInfo> gravestoneInfoMap = new HashMap<UUID, GravestoneInfo>();

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        GravestoneManager.updatePlayerSafePosition(player);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        InventoryManager.capturePreDeathInventory(player);
        ServerLevel level = (ServerLevel)player.level();
        BlockPos deathPos = player.blockPosition();
        boolean shouldCreate = GravestoneManager.shouldCreateGravestone(level, deathPos);
        if (shouldCreate) {
            BlockPos gravestonePos = GravestoneManager.findGravestonePosition(player, level, deathPos);
            UUID playerUUID = player.getUUID();
            level.getServer().tell((Runnable)new TickTask(level.getServer().getTickCount() + 2, () -> {
                boolean created = GravestoneManager.createGravestone(player, level, gravestonePos);
                gravestoneInfoMap.put(playerUUID, new GravestoneInfo(gravestonePos, level, created));
            }));
            gravestoneInfoMap.put(player.getUUID(), new GravestoneInfo(gravestonePos, level, true));
        } else {
            gravestoneInfoMap.put(player.getUUID(), new GravestoneInfo(deathPos, level, false));
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player newPlayer = event.getEntity();
        Player oldPlayer = event.getOriginal();
        UUID playerId = newPlayer.getUUID();
        GravestoneInfo gravestoneInfo = gravestoneInfoMap.get(playerId);
        if (gravestoneInfo == null || !gravestoneInfo.created) {
            InventoryManager.cleanupPlayerData(playerId);
            gravestoneInfoMap.remove(playerId);
            return;
        }
        List<ItemStack> preDeathInventory = InventoryManager.getPreDeathInventory(playerId);
        if (preDeathInventory == null) {
            SoulGravestone.LOGGER.warn("No pre-death inventory found for player: " + newPlayer.getName().getString());
            InventoryManager.cleanupPlayerData(playerId);
            gravestoneInfoMap.remove(playerId);
            return;
        }
        BlockEntity be = gravestoneInfo.level.getBlockEntity(gravestoneInfo.position);
        if (!(be instanceof GravestoneBlockEntity)) {
            SoulGravestone.LOGGER.warn("Could not find gravestone for player: " + newPlayer.getName().getString());
            InventoryManager.cleanupPlayerData(playerId);
            gravestoneInfoMap.remove(playerId);
            return;
        }
        GravestoneBlockEntity gravestoneBE = (GravestoneBlockEntity)be;
        gravestoneBE.ensureInventorySize(newPlayer);
        InventoryManager.transferLostItemsToGravestone(newPlayer, preDeathInventory, gravestoneBE);
        if (ModList.get().isLoaded("curios")) {
            List<ItemStack> preDeathCuriosItems = InventoryManager.getPreDeathCurios(playerId);
            CuriosManager.handlePlayerCloneCuriosWithComparison(oldPlayer, newPlayer, gravestoneBE, preDeathCuriosItems);
        }
        InventoryManager.cleanupPlayerData(playerId);
        gravestoneInfoMap.remove(playerId);
    }

    @SubscribeEvent
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (event.getEntity() instanceof Player) {
            event.setDroppedExperience(0);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Player player;
        GravestoneInfo gravestoneInfo;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (gravestoneInfo = gravestoneInfoMap.get((player = (Player)livingEntity).getUUID())) != null && gravestoneInfo.created) {
            event.getDrops().clear();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickGravestone(PlayerInteractEvent.RightClickBlock event) {
        GravestoneManager.handleGravestoneRetrieval(event);
    }

    private static class GravestoneInfo {
        final BlockPos position;
        final ServerLevel level;
        final boolean created;

        GravestoneInfo(BlockPos position, ServerLevel level, boolean created) {
            this.position = position;
            this.level = level;
            this.created = created;
        }
    }
}

