/*
 * Decompiled with CFR 0.152.
 */
package com.nouho.soulgravestone.managers;

import com.nouho.soulgravestone.SoulGravestone;
import com.nouho.soulgravestone.gravestone.GravestoneBlockEntity;
import com.nouho.soulgravestone.managers.CuriosManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.ModList;

public class InventoryManager {
    private static final Map<UUID, List<ItemStack>> preDeathInventories = new HashMap<UUID, List<ItemStack>>();
    private static final Map<UUID, List<ItemStack>> preDeathCurios = new HashMap<UUID, List<ItemStack>>();

    public static void capturePreDeathInventory(Player player) {
        int i;
        ArrayList<ItemStack> preDeathInventory = new ArrayList<ItemStack>();
        for (i = 0; i < 36; ++i) {
            preDeathInventory.add(player.getInventory().getItem(i).copy());
        }
        for (i = 0; i < 4; ++i) {
            preDeathInventory.add(((ItemStack)player.getInventory().armor.get(i)).copy());
        }
        preDeathInventory.add(((ItemStack)player.getInventory().offhand.get(0)).copy());
        preDeathInventories.put(player.getUUID(), preDeathInventory);
        if (ModList.get().isLoaded("curios")) {
            List<ItemStack> preDeathCuriosItems = CuriosManager.capturePreDeathCurios(player);
            preDeathCurios.put(player.getUUID(), preDeathCuriosItems);
        }
    }

    public static List<ItemStack> getPreDeathInventory(UUID playerId) {
        return preDeathInventories.get(playerId);
    }

    public static List<ItemStack> getPreDeathCurios(UUID playerId) {
        return preDeathCurios.get(playerId);
    }

    public static void transferLostItemsToGravestone(Player newPlayer, List<ItemStack> preDeathInventory, GravestoneBlockEntity gravestoneBE) {
        int i;
        for (i = 0; i < 36; ++i) {
            ItemStack preDeathStack = i < preDeathInventory.size() ? preDeathInventory.get(i) : ItemStack.EMPTY;
            ItemStack currentStack = newPlayer.getInventory().getItem(i);
            if (preDeathStack.isEmpty() || ItemStack.matches((ItemStack)preDeathStack, (ItemStack)currentStack)) continue;
            gravestoneBE.getInventory().set(i, (Object)preDeathStack.copy());
        }
        for (i = 0; i < 4; ++i) {
            int preDeathIndex = 36 + i;
            ItemStack preDeathStack = preDeathIndex < preDeathInventory.size() ? preDeathInventory.get(preDeathIndex) : ItemStack.EMPTY;
            ItemStack currentStack = (ItemStack)newPlayer.getInventory().armor.get(i);
            if (preDeathStack.isEmpty() || ItemStack.matches((ItemStack)preDeathStack, (ItemStack)currentStack)) continue;
            gravestoneBE.getInventory().set(36 + i, (Object)preDeathStack.copy());
        }
        ItemStack preDeathOffhand = 40 < preDeathInventory.size() ? preDeathInventory.get(40) : ItemStack.EMPTY;
        ItemStack currentOffhand = (ItemStack)newPlayer.getInventory().offhand.get(0);
        if (!preDeathOffhand.isEmpty() && !ItemStack.matches((ItemStack)preDeathOffhand, (ItemStack)currentOffhand)) {
            gravestoneBE.getInventory().set(40, (Object)preDeathOffhand.copy());
        }
    }

    public static void restoreGravestoneContents(Level level, BlockPos pos, Player player) {
        BlockEntity be;
        if (level.isClientSide) {
            return;
        }
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.getItem() != Items.COMPASS || !stack.has(DataComponents.LODESTONE_TRACKER)) continue;
            inventory.removeItem(i, stack.getCount());
            SoulGravestone.clearGravestonePosition(player);
            break;
        }
        if ((be = level.getBlockEntity(pos)) instanceof GravestoneBlockEntity) {
            int storedXp;
            ItemStack stack;
            int i;
            GravestoneBlockEntity gravestoneBE = (GravestoneBlockEntity)be;
            NonNullList<ItemStack> inv = gravestoneBE.getInventory();
            Inventory playerInv = player.getInventory();
            for (i = 0; i < 36; ++i) {
                stack = (ItemStack)inv.get(i);
                if (stack.isEmpty()) continue;
                if (playerInv.getItem(i).isEmpty()) {
                    playerInv.setItem(i, stack);
                } else if (!playerInv.add(stack)) {
                    player.drop(stack, false);
                }
                inv.set(i, (Object)ItemStack.EMPTY);
            }
            for (i = 0; i < 4; ++i) {
                stack = (ItemStack)inv.get(36 + i);
                if (stack.isEmpty()) continue;
                if (((ItemStack)playerInv.armor.get(i)).isEmpty()) {
                    playerInv.armor.set(i, (Object)stack);
                } else if (!playerInv.add(stack)) {
                    player.drop(stack, false);
                }
                inv.set(36 + i, (Object)ItemStack.EMPTY);
            }
            ItemStack offhandStack = (ItemStack)inv.get(40);
            if (!offhandStack.isEmpty()) {
                if (((ItemStack)playerInv.offhand.get(0)).isEmpty()) {
                    playerInv.offhand.set(0, (Object)offhandStack);
                } else if (!playerInv.add(offhandStack)) {
                    player.drop(offhandStack, false);
                }
                inv.set(40, (Object)ItemStack.EMPTY);
            }
            if ((storedXp = gravestoneBE.getStoredXp()) > 0) {
                player.giveExperiencePoints(storedXp);
                gravestoneBE.setStoredXp(0);
            }
            if (ModList.get().isLoaded("curios")) {
                CuriosManager.handlePlayerRetrieveCurios(player, gravestoneBE);
            }
        }
    }

    public static void cleanupPlayerData(UUID playerId) {
        preDeathInventories.remove(playerId);
        preDeathCurios.remove(playerId);
    }

    public static int getPlayerTotalXP(Player player) {
        int level = player.experienceLevel;
        float progress = player.experienceProgress;
        int xp = InventoryManager.getTotalXpForLevel(level);
        return xp += (int)(progress * (float)player.getXpNeededForNextLevel());
    }

    private static int getTotalXpForLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }
}

