/*
 * Decompiled with CFR 0.152.
 */
package vesper.aiutd;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import vesper.aiutd.AIUTDClient;
import vesper.aiutd.AIUTDClientConfig;

public class AIUTDChatMessage {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void chatMessageInit() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public Component clickableLink(String message, String URL) {
        MutableComponent linkLog = Component.literal((String)message).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, URL)).withUnderlined(Boolean.valueOf(true)).withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)));
        return linkLog;
    }

    public Component toIgnore() {
        MutableComponent toIgnore = Component.literal((String)"Run the command '/shouldIgnore' to hide this message").setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true)));
        return toIgnore;
    }

    public Component ignoreMsg() {
        MutableComponent ignore = Component.literal((String)"Ignore update messages").setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/shouldIgnore")).withUnderlined(Boolean.valueOf(true)).withItalic(Boolean.valueOf(true)).withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)));
        return ignore;
    }

    @SubscribeEvent
    private void chatMessageDisplay(ClientPlayerNetworkEvent.LoggingIn event) {
        LOGGER.info(String.valueOf(AIUTDClientConfig.chatAlert));
        if (AIUTDClientConfig.chatAlert == Boolean.TRUE && AIUTDClient.needUpdate == Boolean.TRUE) {
            if (AIUTDClientConfig.useCustomMessage == Boolean.TRUE && !Objects.equals(AIUTDClientConfig.customMessage, "This is a custom message!") && AIUTDClientConfig.shouldIgnore == Boolean.FALSE) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage((Component)Component.literal((String)AIUTDClientConfig.customMessage), false));
                }
                if (AIUTDClientConfig.linkChangelog == Boolean.TRUE && minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage(this.clickableLink("Read the changelog!", AIUTDClientConfig.changelogLink), false));
                }
                assert (minecraft.player != null);
                minecraft.player.displayClientMessage(this.toIgnore(), false);
            } else if (AIUTDClientConfig.useModpackName == Boolean.TRUE && !Objects.equals(AIUTDClientConfig.modpackName, "Default") && AIUTDClientConfig.useCustomMessage == Boolean.FALSE && AIUTDClientConfig.shouldIgnore == Boolean.FALSE) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage((Component)Component.literal((String)("There is an update available for " + AIUTDClientConfig.modpackName + "!")), false));
                }
                if (AIUTDClientConfig.linkChangelog == Boolean.TRUE && minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage(this.clickableLink("Read the changelog!", AIUTDClientConfig.changelogLink), false));
                }
                assert (minecraft.player != null);
                minecraft.player.displayClientMessage(this.toIgnore(), false);
            } else if (AIUTDClientConfig.shouldIgnore == Boolean.FALSE) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage((Component)Component.literal((String)"There is an update available for your modpack!"), false));
                }
                if (AIUTDClientConfig.linkChangelog == Boolean.TRUE && minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage(this.clickableLink("Read the changelog!", AIUTDClientConfig.changelogLink), false));
                }
                assert (minecraft.player != null);
                minecraft.player.displayClientMessage(this.toIgnore(), false);
            }
        }
    }
}

