/*
 * Decompiled with CFR 0.152.
 */
package vesper.aiutd;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vesper.aiutd.AIUTDClientConfig;

public class VersionGrabber {
    private static final Logger log = LoggerFactory.getLogger(VersionGrabber.class);

    public static String getLatestVersion(int location) {
        StringBuilder result = new StringBuilder();
        try {
            URI url = new URI(AIUTDClientConfig.versionAPI);
            HttpURLConnection conn = (HttpURLConnection)url.toURL().openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                log.error("HTTP request failed with response code: " + responseCode);
                return AIUTDClientConfig.versionCache;
            }
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String line;
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
            }
            JsonArray jsonArray = JsonParser.parseString((String)result.toString()).getAsJsonArray();
            if (!jsonArray.isEmpty() && location < jsonArray.size()) {
                String versionNumber;
                JsonObject versionObject = jsonArray.get(location).getAsJsonObject();
                AIUTDClientConfig.versionCache = versionNumber = versionObject.get("version_number").getAsString();
                return versionNumber;
            }
        }
        catch (Exception fetchVersionError) {
            log.error("fetchVersionError: ", (Throwable)fetchVersionError);
            log.info("If this is first launch this error can be ignored");
            return AIUTDClientConfig.versionCache;
        }
        return null;
    }
}

