/*
 * Decompiled with CFR 0.152.
 */
package vesper.aiutd.mixin.client;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vesper.aiutd.AIUTDClientConfig;
import vesper.aiutd.VersionCheck;
import vesper.aiutd.VersionGrabber;

@Mixin(value={TitleScreen.class})
public abstract class TitleScreenMixin
extends Screen {
    private static final Logger log = LogManager.getLogger(TitleScreenMixin.class);
    private static boolean needUpdate;

    protected TitleScreenMixin(Component title) {
        super(title);
    }

    private static void setVersion() {
        String localVersion = AIUTDClientConfig.localVersion;
        String modpackVersion = VersionGrabber.getLatestVersion(VersionCheck.loaderLocation);
        needUpdate = Objects.equals(localVersion, modpackVersion) ? Boolean.FALSE.booleanValue() : Boolean.TRUE.booleanValue();
    }

    @Inject(at={@At(value="RETURN")}, method={"createNormalMenuOptions"})
    private void addUpdateNotice(CallbackInfo ci) throws InterruptedException {
        TitleScreenMixin.setVersion();
        if (needUpdate && AIUTDClientConfig.menuAlert) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"Update Available"), button -> {
                try {
                    URI url = new URI(AIUTDClientConfig.changelogLink);
                    String os = System.getProperty("os.name").toLowerCase();
                    try {
                        if (os.contains("win")) {
                            Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", String.valueOf(url)});
                        } else if (os.contains("mac")) {
                            Runtime.getRuntime().exec(new String[]{"open", String.valueOf(url)});
                        } else if (os.contains("nix") || os.contains("nux")) {
                            Runtime.getRuntime().exec(new String[]{"xdg-open", String.valueOf(url)});
                        } else {
                            System.out.println("Unsupported OS for opening a browser.");
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (Exception e) {
                    log.error("e: ", (Throwable)e);
                }
            }).bounds(this.width / 2 - 100 + 205, this.height / 4 + 32, 90, 20).build());
        }
    }
}

