/*
 * Decompiled with CFR 0.152.
 */
package vesper.aiutd;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import eu.midnightdust.lib.config.MidnightConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;
import vesper.aiutd.AIUTDChatMessage;
import vesper.aiutd.AIUTDClientConfig;
import vesper.aiutd.VersionCheck;

@Mod(value="aiutd")
public class AIUTDClient {
    public static final String MODID = "aiutd";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean needUpdate;
    private static boolean shouldIgnore;

    public AIUTDClient(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
    }

    public static String getLatestVersion() {
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL url = new URL(AIUTDClientConfig.versionAPI);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            rd.close();
            JsonArray jsonArray = JsonParser.parseString((String)result.toString()).getAsJsonArray();
            if (!jsonArray.isEmpty()) {
                JsonElement getVersionElement = jsonArray.get(0);
                return getVersionElement.getAsJsonObject().get("version_number").getAsString();
            }
        }
        catch (Exception fetchVersionError) {
            LOGGER.error("fetchVersionError: ", (Throwable)fetchVersionError);
            LOGGER.info("If this is first launch this error can be ignored");
        }
        return null;
    }

    public static void setVersion() {
        String localVersion = AIUTDClientConfig.localVersion;
        String modpackVersion = AIUTDClient.getLatestVersion();
        needUpdate = Objects.equals(localVersion, modpackVersion) ? Boolean.FALSE.booleanValue() : Boolean.TRUE.booleanValue();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MidnightConfig.init((String)MODID, AIUTDClientConfig.class);
    }

    static {
        shouldIgnore = false;
    }

    @EventBusSubscriber(modid="aiutd", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) throws URISyntaxException, IOException {
            try {
                if (!VersionCheck.hasChecked) {
                    VersionCheck.setVersion();
                    VersionCheck.hasChecked = true;
                }
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
            new AIUTDChatMessage().chatMessageInit();
        }
    }
}

