/*
 * Decompiled with CFR 0.152.
 */
package vesper.aiutd;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vesper.aiutd.AIUTDClientConfig;
import vesper.aiutd.VersionGrabber;

public class VersionCheck {
    private static final Logger log = LoggerFactory.getLogger(VersionCheck.class);
    public static boolean needUpdate;
    public static int loaderLocation;
    public static String localLoader;
    public static String modpackVersion;
    public static String versionLoader;
    public static String APIMcVersion;
    public static String clientVersion;
    static boolean hasChecked;

    public static void setVersion() throws URISyntaxException, IOException {
        JsonArray jsonArray;
        clientVersion = Minecraft.getInstance().getLaunchedVersion();
        URI url = new URI(AIUTDClientConfig.versionAPI);
        StringBuilder result = new StringBuilder();
        HttpURLConnection conn = (HttpURLConnection)url.toURL().openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            log.error("HTTP request failed with response code: " + responseCode);
            return;
        }
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            log.error("Error reading version API response: ", (Throwable)e);
            return;
        }
        try {
            jsonArray = JsonParser.parseString((String)result.toString()).getAsJsonArray();
        }
        catch (Exception e) {
            log.error("Failed to parse version JSON: ", (Throwable)e);
            return;
        }
        if (jsonArray.isEmpty()) {
            log.error("Version JSON is empty.");
            return;
        }
        if (AIUTDClientConfig.multiLoaderBool) {
            switch (AIUTDClientConfig.multiLoader) {
                case FABRIC: {
                    localLoader = "fabric";
                    break;
                }
                case QUILT: {
                    localLoader = "quilt";
                    break;
                }
                case NEOFORGE: {
                    localLoader = "neoforge";
                }
            }
        }
        for (int timesChecked = 0; loaderLocation < jsonArray.size() && timesChecked <= AIUTDClientConfig.maxChecks && !hasChecked; ++loaderLocation, ++timesChecked) {
            JsonObject versionObject = jsonArray.get(loaderLocation).getAsJsonObject();
            JsonArray gameVersionsArray = versionObject.getAsJsonArray("game_versions");
            JsonArray loadersArray = versionObject.getAsJsonArray("loaders");
            log.info("the check has run");
            if (AIUTDClientConfig.multiLoaderBool && AIUTDClientConfig.multiVersion) {
                boolean versionMatch = false;
                boolean loaderMatch = false;
                if (gameVersionsArray != null && !gameVersionsArray.isEmpty()) {
                    APIMcVersion = gameVersionsArray.get(0).getAsString();
                    versionMatch = Objects.equals(clientVersion, APIMcVersion);
                }
                if (loadersArray != null && !loadersArray.isEmpty()) {
                    versionLoader = loadersArray.get(0).getAsString();
                    loaderMatch = Objects.equals(versionLoader, localLoader);
                }
                if (!versionMatch || !loaderMatch) continue;
                break;
            }
            if (AIUTDClientConfig.multiLoaderBool) {
                if (loadersArray == null || loadersArray.isEmpty() || !Objects.equals(versionLoader = loadersArray.get(0).getAsString(), localLoader)) continue;
                break;
            }
            if (AIUTDClientConfig.multiVersion) {
                if (gameVersionsArray == null || gameVersionsArray.isEmpty() || !Objects.equals(clientVersion, APIMcVersion = gameVersionsArray.get(0).getAsString())) continue;
                break;
            }
            loaderLocation = 0;
            break;
        }
        needUpdate = !Objects.equals(AIUTDClientConfig.localVersion, modpackVersion = VersionGrabber.getLatestVersion(loaderLocation));
    }

    static {
        loaderLocation = 0;
        modpackVersion = AIUTDClientConfig.localVersion;
        versionLoader = "";
        APIMcVersion = "";
        hasChecked = false;
    }
}

