/*
 * Decompiled with CFR 0.152.
 */
package dev.vesper.AIUTD.neoforge;

import dev.vesper.AIUTD.common.UpdateChecker;
import dev.vesper.AIUTD.config.Config;
import dev.vesper.AIUTD.config.EndUserConfig;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ChatMessagesNeoForge {
    public void chatMessageInit() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public Component clickableLink(String message, String URL2) {
        return Component.literal((String)message).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, URL2)).withUnderlined(Boolean.valueOf(true)).withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)));
    }

    public Component toIgnore() {
        return Component.translatable((String)"aiutd.runToIgnore").setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true)));
    }

    @SubscribeEvent
    private void chatMessageDisplay(ClientPlayerNetworkEvent.LoggingIn event) {
        if (Config.chatAlert && UpdateChecker.needUpdate) {
            if (Config.useCustomMessage && !Objects.equals(Config.customMessage, "This is a custom message!") && !EndUserConfig.shouldIgnore) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage((Component)Component.literal((String)Config.customMessage), false));
                }
                if (Config.linkChangelog && minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage(this.clickableLink("Read the changelog!", Config.changelogLink), false));
                }
                assert (minecraft.player != null);
                minecraft.player.displayClientMessage(this.toIgnore(), false);
            } else if (Config.useModpackName && !Objects.equals(Config.modpackName, "Default") && !Config.useCustomMessage && !EndUserConfig.shouldIgnore) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage((Component)Component.translatable((String)("aiutd.modPackNameMsg" + Config.modpackName + "!")), false));
                }
                if (Config.linkChangelog && minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage(this.clickableLink("Read the changelog!", Config.changelogLink), false));
                }
                assert (minecraft.player != null);
                minecraft.player.displayClientMessage(this.toIgnore(), false);
            } else if (!EndUserConfig.shouldIgnore) {
                Minecraft minecraft = Minecraft.getInstance();
                if (minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage((Component)Component.translatable((String)"aiutd.defaultMsg"), false));
                }
                if (Config.linkChangelog && minecraft.player != null) {
                    minecraft.execute(() -> minecraft.player.displayClientMessage(this.clickableLink("Read the changelog!", Config.changelogLink), false));
                }
                assert (minecraft.player != null);
                minecraft.player.displayClientMessage(this.toIgnore(), false);
            }
        }
    }
}

