/*
 * Decompiled with CFR 0.152.
 */
package dev.vesper.AIUTD.common;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import dev.vesper.AIUTD.AIUTD;
import dev.vesper.AIUTD.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker {
    public static boolean needUpdate;
    public static boolean hasChecked;
    public static String clientVersion;
    public static int location;
    public static String APIMcVersion;
    public static String versionLoader;
    public static String localLoader;

    @Nullable
    public static String getVersionNumber() throws URISyntaxException, IOException {
        String versionNumber;
        JSONObject matchedVersion;
        JSONArray versionsArray;
        clientVersion = Minecraft.getInstance().getLaunchedVersion();
        URI url = new URI(Config.versionAPI);
        StringBuilder result = new StringBuilder();
        HttpURLConnection urlConnection = (HttpURLConnection)url.toURL().openConnection();
        urlConnection.setRequestMethod("GET");
        urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0");
        int responseCode = urlConnection.getResponseCode();
        if (responseCode != 200) {
            AIUTD.LOG.error("HTTP request failed with response code: {}", (Object)responseCode);
            AIUTD.LOG.info("Proceeding using cached version: {}", (Object)Config.versionCache);
            return Config.versionCache;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Exception e) {
            AIUTD.LOG.error("Error reading version API response: ", (Throwable)e);
            AIUTD.LOG.info("Proceeding using cached version: {}", (Object)Config.versionCache);
            return Config.versionCache;
        }
        try {
            versionsArray = JSON.parseArray((String)result.toString());
        }
        catch (Exception e) {
            AIUTD.LOG.error("Failed to parse version JSON: ", (Throwable)e);
            AIUTD.LOG.info("Proceeding using cached version: {}", (Object)Config.versionCache);
            return Config.versionCache;
        }
        if (versionsArray.isEmpty() || versionsArray == null) {
            AIUTD.LOG.error("Version JSON is Empty or Null");
            AIUTD.LOG.info("Proceeding using cached version: {}", (Object)Config.versionCache);
            return Config.versionCache;
        }
        if (Config.multiLoaderBool) {
            switch (Config.multiLoader) {
                case FABRIC: {
                    localLoader = "fabric";
                    break;
                }
                case QUILT: {
                    localLoader = "quilt";
                    break;
                }
                case NEOFORGE: {
                    localLoader = "neoforge";
                }
            }
        }
        if ((matchedVersion = UpdateChecker.findMatchingVersion(versionsArray)) != null && (versionNumber = matchedVersion.getString("version_number")) != null) {
            Config.versionCache = versionNumber;
            hasChecked = true;
            return versionNumber;
        }
        AIUTD.LOG.info("No matching version found, using cached version: {}", (Object)Config.versionCache);
        return Config.versionCache;
    }

    private static JSONObject findMatchingVersion(JSONArray versionsArray) {
        for (int i = 0; i < versionsArray.size(); ++i) {
            JSONObject version = versionsArray.getJSONObject(i);
            if (version == null) continue;
            JSONArray gameVersions = version.getJSONArray("game_versions");
            JSONArray loaders = version.getJSONArray("loaders");
            if (Config.multiLoaderBool && Config.multiVersion) {
                if (!UpdateChecker.matchesGameVersion(gameVersions) || !UpdateChecker.matchesLoader(loaders)) continue;
                return version;
            }
            if (Config.multiLoaderBool) {
                if (!UpdateChecker.matchesLoader(loaders)) continue;
                return version;
            }
            if (Config.multiVersion) {
                if (!UpdateChecker.matchesGameVersion(gameVersions)) continue;
                return version;
            }
            return version;
        }
        return null;
    }

    public static boolean matchesGameVersion(JSONArray gameVersions) {
        if (gameVersions != null && !gameVersions.isEmpty()) {
            APIMcVersion = gameVersions.getString(0);
            return Objects.equals(clientVersion, APIMcVersion);
        }
        return false;
    }

    private static boolean matchesLoader(JSONArray loaders) {
        if (loaders != null && !loaders.isEmpty()) {
            versionLoader = loaders.getString(0);
            return Objects.equals(versionLoader, localLoader);
        }
        return false;
    }

    static {
        hasChecked = false;
        location = 0;
        APIMcVersion = "";
        versionLoader = "";
    }
}

