/*
 * Decompiled with CFR 0.152.
 */
package ru.andcool.magnets;

import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.andcool.magnets.MagnetPlugin;
import ru.andcool.magnets.MagnetTask;

public class MagnetCommand
implements CommandExecutor {
    private final MagnetPlugin plugin;

    public MagnetCommand(MagnetPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String sub;
        if (args.length == 0) {
            sender.sendMessage("\u00a7Usage: /magnet <start|stop|status>");
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "start": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cOnly players can execute this command");
                    return true;
                }
                Player player = (Player)sender;
                if (args.length < 6) {
                    sender.sendMessage("\u00a7cUsage: /magnet start <x> <y> <z> <radius> <maxStrength>");
                    return true;
                }
                try {
                    double x = Double.parseDouble(args[1]);
                    double y = Double.parseDouble(args[2]);
                    double z = Double.parseDouble(args[3]);
                    double radius = Double.parseDouble(args[4]);
                    double strength = Double.parseDouble(args[5]);
                    Location target = new Location(player.getWorld(), x, y, z);
                    MagnetTask task = new MagnetTask(target, radius, strength);
                    task.runTaskTimer((Plugin)this.plugin, 0L, 1L);
                    MagnetPlugin.setTask(task);
                    this.plugin.getConfig().set("magnet.enabled", (Object)true);
                    this.plugin.getConfig().set("magnet.world", (Object)player.getWorld().getName());
                    this.plugin.getConfig().set("magnet.x", (Object)x);
                    this.plugin.getConfig().set("magnet.y", (Object)y);
                    this.plugin.getConfig().set("magnet.z", (Object)z);
                    this.plugin.getConfig().set("magnet.radius", (Object)radius);
                    this.plugin.getConfig().set("magnet.strength", (Object)strength);
                    this.plugin.saveConfig();
                    sender.sendMessage("\u00a7aMagnet activated!");
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7Error: Cannot parse parameters as numbers!");
                }
                break;
            }
            case "stop": {
                MagnetTask task = MagnetPlugin.getTask();
                if (task == null) {
                    sender.sendMessage("\u00a7eMagnet not activated");
                    break;
                }
                task.cancel();
                MagnetPlugin.setTask(null);
                sender.sendMessage("\u00a7aMagnet stopped");
                this.plugin.getConfig().set("magnet.enabled", (Object)false);
                this.plugin.saveConfig();
                break;
            }
            case "status": {
                MagnetTask task = MagnetPlugin.getTask();
                if (task == null) {
                    sender.sendMessage("\u00a7eMagnet inactive");
                    break;
                }
                sender.sendMessage("\u00a7aMagnet is active:");
                sender.sendMessage("\u00a77Center: " + task.getTarget().getBlockX() + " " + task.getTarget().getBlockY() + " " + task.getTarget().getBlockZ());
                sender.sendMessage("\u00a77Radius: " + task.getRadius() + ", strength: " + task.getMaxStrength());
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. Use: start, stop, status.");
            }
        }
        return true;
    }
}

