/*
 * Decompiled with CFR 0.152.
 */
package ru.andcool.magnets;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.andcool.magnets.MagnetCommand;
import ru.andcool.magnets.MagnetTask;

public class MagnetPlugin
extends JavaPlugin {
    private static MagnetTask currentTask;

    public void onEnable() {
        this.saveDefaultConfig();
        Objects.requireNonNull(this.getCommand("magnet")).setExecutor((CommandExecutor)new MagnetCommand(this));
        this.getLogger().info("Magnet plugin activated!");
        if (this.getConfig().getBoolean("magnet.enabled")) {
            double x = this.getConfig().getDouble("magnet.x");
            double y = this.getConfig().getDouble("magnet.y");
            double z = this.getConfig().getDouble("magnet.z");
            double radius = this.getConfig().getDouble("magnet.radius");
            double strength = this.getConfig().getDouble("magnet.strength");
            String worldName = this.getConfig().getString("magnet.world");
            assert (worldName != null);
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                Location target = new Location(world, x, y, z);
                MagnetTask task = new MagnetTask(target, radius, strength);
                task.runTaskTimer((Plugin)this, 0L, 1L);
                MagnetPlugin.setTask(task);
                this.getLogger().info("Started magnet at world " + worldName);
            } else {
                this.getLogger().warning("World " + worldName + " not found. Magnet stopped.");
            }
        }
    }

    public void onDisable() {
        if (currentTask != null) {
            currentTask.cancel();
            currentTask = null;
        }
        this.getLogger().info("Magnet plugin disabled.");
    }

    public static void setTask(MagnetTask task) {
        if (currentTask != null) {
            currentTask.cancel();
        }
        currentTask = task;
    }

    public static MagnetTask getTask() {
        return currentTask;
    }
}

