/*
 * Decompiled with CFR 0.152.
 */
package ru.andcool.magnets;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MagnetTask
extends BukkitRunnable {
    private final Location target;
    private final double radius;
    private final double maxStrength;
    private final Set<Material> ItemsList = EnumSet.of(Material.IRON_HELMET, new Material[]{Material.IRON_CHESTPLATE, Material.IRON_AXE, Material.IRON_ORE, Material.IRON_PICKAXE, Material.IRON_BOOTS, Material.IRON_TRAPDOOR, Material.IRON_SWORD, Material.IRON_BARS, Material.IRON_INGOT, Material.IRON_LEGGINGS, Material.IRON_BLOCK, Material.IRON_DOOR, Material.IRON_HOE, Material.IRON_HORSE_ARMOR, Material.IRON_SHOVEL, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS, Material.NETHERITE_AXE, Material.NETHERITE_PICKAXE, Material.NETHERITE_SWORD, Material.NETHERITE_HOE, Material.NETHERITE_SHOVEL, Material.NETHERITE_INGOT, Material.NETHERITE_BLOCK, Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE, Material.ANCIENT_DEBRIS, Material.NETHERITE_SCRAP});
    private final Set<String> EntitiesList = Set.of("IRON_GOLEM", "MINECART", "ENDER_PEARL");

    public MagnetTask(Location target, double radius, double maxStrength) {
        this.target = target;
        this.radius = radius;
        this.maxStrength = maxStrength;
    }

    public void run() {
        World world = this.target.getWorld();
        if (world == null) {
            return;
        }
        for (Entity entity : world.getEntities()) {
            double radiusSquared;
            double dz;
            double dy;
            double dx;
            double distanceSquared;
            if (entity instanceof ItemFrame || entity instanceof ArmorStand || (distanceSquared = (dx = this.target.getX() - entity.getX()) * dx + (dy = this.target.getY() - entity.getY()) * dy + (dz = this.target.getZ() - entity.getZ()) * dz) > (radiusSquared = this.radius * this.radius) || distanceSquared == 0.0) continue;
            Vector vector = new Vector(dx, dy, dz);
            double distance = Math.sqrt(distanceSquared);
            vector.normalize();
            double strength = (this.radius - distance) / this.radius * this.maxStrength;
            if (strength > 0.5) {
                strength = 0.5;
            }
            if (strength < 0.02) continue;
            vector.multiply(strength);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack[] armor = player.getInventory().getArmorContents();
                ItemStack hand = player.getInventory().getItemInMainHand();
                ItemStack hand_secondary = player.getInventory().getItemInOffHand();
                if (player.getGameMode() == GameMode.CREATIVE || !Arrays.stream(armor).anyMatch(i -> {
                    if (i != null) {
                        return this.ItemsList.contains(i.getType());
                    }
                    return false;
                }) && !this.ItemsList.contains(hand.getType()) && !this.ItemsList.contains(hand_secondary.getType())) continue;
                player.setVelocity(player.getVelocity().add(vector));
                continue;
            }
            if (entity instanceof Item) {
                if (!this.ItemsList.contains(((Item)entity).getItemStack().getType())) continue;
                entity.setVelocity(entity.getVelocity().add(vector));
                continue;
            }
            if (!this.EntitiesList.contains(entity.getType().name())) continue;
            entity.setVelocity(entity.getVelocity().add(vector));
        }
        if (world.getFullTime() % 10L == 0L) {
            for (Player player : world.getPlayers()) {
                if (!(player.getLocation().distanceSquared(this.target) <= this.radius * this.radius)) continue;
                player.playSound(this.target, Sound.BLOCK_BEACON_AMBIENT, 2.0f, 1.0f);
            }
        }
    }

    public Location getTarget() {
        return this.target;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getMaxStrength() {
        return this.maxStrength;
    }
}

