/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.command;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.tomalbrc.bil.BIL;
import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.api.AnimatedEntityHolder;
import de.tomalbrc.bil.api.VariantController;
import de.tomalbrc.bil.core.extra.ModelEntity;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Variant;
import de.tomalbrc.bil.file.loader.AjBlueprintLoader;
import de.tomalbrc.bil.file.loader.AjModelLoader;
import de.tomalbrc.bil.file.loader.BbModelLoader;
import de.tomalbrc.bil.util.Utils;
import java.util.Collection;
import java.util.HexFormat;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class ModelCommand {
    private static final String TARGETS = "targets";
    private static final String ANIMATION = "animation";

    public static ArgumentBuilder<class_2168, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"model").requires(source -> source.method_9259(2));
        builder.then(ModelCommand.modelCreator());
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)TARGETS, (ArgumentType)class_2186.method_9306()).then(ModelCommand.scaleManipulator())).then(ModelCommand.colorManipulator())).then(ModelCommand.variantManipulator())).then(ModelCommand.animationManipulator()));
        return builder;
    }

    private static int manipulateModels(class_2168 source, Collection<? extends class_1297> targets, Consumer<AnimatedEntityHolder> consumer) {
        int count = 0;
        for (class_1297 class_12972 : targets) {
            AnimatedEntityHolder holder = AnimatedEntity.getHolder(class_12972);
            if (holder == null) continue;
            consumer.accept(holder);
            ++count;
        }
        if (count <= 0) {
            source.method_9213((class_2561)class_2561.method_43470((String)"No models found!"));
        }
        return count;
    }

    private static int spawnModel(class_2168 source, String path) throws CommandSyntaxException {
        class_2960 resource = class_2960.method_60654((String)path);
        if (path.endsWith(".ajmodel")) {
            return ModelCommand.substituteModelLoader(source, path, "ajmodel", newResource -> new AjModelLoader().loadResource((class_2960)newResource));
        }
        if (path.endsWith(".ajblueprint")) {
            return ModelCommand.substituteModelLoader(source, path, "ajblueprint", newResource -> new AjBlueprintLoader().loadResource((class_2960)newResource));
        }
        return ModelCommand.spawnModel(source, () -> new BbModelLoader().loadResource(resource), path);
    }

    private static int substituteModelLoader(class_2168 source, String path, String suffix, Function<class_2960, Model> function) throws CommandSyntaxException {
        String newPath = path.replace("." + suffix, "");
        class_2960 newResource = class_2960.method_60654((String)newPath);
        return ModelCommand.spawnModel(source, () -> (Model)function.apply(newResource), newPath);
    }

    private static int spawnModel(class_2168 source, Supplier<Model> supplier, String path) throws CommandSyntaxException {
        class_3218 level = source.method_9225();
        class_243 pos = source.method_9222();
        class_241 rot = source.method_9210();
        try {
            Model model = supplier.get();
            ModelEntity entity = new ModelEntity((class_1937)level, model);
            entity.method_66246(pos, rot.field_1342, rot.field_1343);
            level.method_8649((class_1297)entity);
            source.method_9226(() -> class_2561.method_43470((String)"Successfully spawned model!"), false);
        }
        catch (JsonParseException ex) {
            BIL.LOGGER.error("{} is not a valid model file!", (Object)path, (Object)ex);
            throw Utils.buildCommandException(ex.getMessage() + "\nCheck the server console for more information.");
        }
        catch (Throwable throwable) {
            throw Utils.buildCommandException("Failed to load model!\n" + throwable.getMessage());
        }
        return 1;
    }

    private static ArgumentBuilder<class_2168, ?> modelCreator() {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"create");
        builder.then(class_2170.method_9244((String)"model", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ModelCommand.spawnModel((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"model"))));
        return builder;
    }

    private static ArgumentBuilder<class_2168, ?> scaleManipulator() {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"scale");
        builder.then(class_2170.method_9244((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).executes(context -> {
            float scale = FloatArgumentType.getFloat((CommandContext)context, (String)"scale");
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> holder.setScale(scale));
        }));
        return builder;
    }

    private static ArgumentBuilder<class_2168, ?> colorManipulator() {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"color");
        builder.then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).executes(context -> {
            int color = ModelCommand.convertHexCode(StringArgumentType.getString((CommandContext)context, (String)"color"));
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> holder.setColor(color));
        }));
        return builder;
    }

    private static ArgumentBuilder<class_2168, ?> variantManipulator() {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"variant");
        builder.then(class_2170.method_9244((String)"variant", (ArgumentType)StringArgumentType.word()).suggests(ModelCommand.availableVariants()).executes(context -> {
            String variant = StringArgumentType.getString((CommandContext)context, (String)"variant");
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> {
                VariantController controller = holder.getVariantController();
                if (variant.equals("default")) {
                    controller.setDefaultVariant();
                } else {
                    controller.setVariant(variant);
                }
            });
        }));
        return builder;
    }

    private static ArgumentBuilder<class_2168, ?> animationManipulator() {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)ANIMATION);
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)ANIMATION, (ArgumentType)StringArgumentType.word()).suggests(ModelCommand.availableAnimations()).executes(context -> {
            String animation = StringArgumentType.getString((CommandContext)context, (String)ANIMATION);
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> holder.getAnimator().playAnimation(animation));
        })).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"play").executes(context -> {
            String animation = StringArgumentType.getString((CommandContext)context, (String)ANIMATION);
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> holder.getAnimator().playAnimation(animation));
        })).then(class_2170.method_9244((String)"priority", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            String animation = StringArgumentType.getString((CommandContext)context, (String)ANIMATION);
            int priority = IntegerArgumentType.getInteger((CommandContext)context, (String)"priority");
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> holder.getAnimator().playAnimation(animation, priority));
        })))).then(class_2170.method_9247((String)"set-frame").then(class_2170.method_9244((String)"frame", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            String animation = StringArgumentType.getString((CommandContext)context, (String)ANIMATION);
            int frame = IntegerArgumentType.getInteger((CommandContext)context, (String)"frame");
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> holder.getAnimator().setAnimationFrame(animation, frame));
        })))).then(class_2170.method_9247((String)"pause").executes(context -> {
            String animation = StringArgumentType.getString((CommandContext)context, (String)ANIMATION);
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> holder.getAnimator().pauseAnimation(animation));
        }))).then(class_2170.method_9247((String)"stop").executes(context -> {
            String animation = StringArgumentType.getString((CommandContext)context, (String)ANIMATION);
            return ModelCommand.manipulateModels((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)TARGETS), holder -> holder.getAnimator().stopAnimation(animation));
        })));
        return builder;
    }

    private static SuggestionProvider<class_2168> availableAnimations() {
        return (ctx, builder) -> {
            ModelCommand.forEachModel((CommandContext<class_2168>)ctx, model -> {
                for (String animation : model.animations().keySet()) {
                    builder.suggest(animation);
                }
            });
            return builder.buildFuture();
        };
    }

    private static SuggestionProvider<class_2168> availableVariants() {
        return (ctx, builder) -> {
            builder.suggest("default");
            ModelCommand.forEachModel((CommandContext<class_2168>)ctx, model -> {
                for (Variant variant : model.variants().values()) {
                    builder.suggest(variant.name());
                }
            });
            return builder.buildFuture();
        };
    }

    private static void forEachModel(CommandContext<class_2168> ctx, Consumer<Model> consumer) throws CommandSyntaxException {
        for (class_1297 entity : class_2186.method_9317(ctx, (String)TARGETS)) {
            AnimatedEntityHolder holder = AnimatedEntity.getHolder(entity);
            if (holder == null) continue;
            consumer.accept(holder.getModel());
        }
    }

    private static int convertHexCode(String hexCode) throws CommandSyntaxException {
        try {
            return HexFormat.fromHexDigits(hexCode);
        }
        catch (Throwable throwable) {
            throw Utils.buildCommandException("Invalid color: " + throwable.getMessage());
        }
    }
}

