/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.core.holder.base;

import de.tomalbrc.bil.api.AnimatedHolder;
import de.tomalbrc.bil.api.Animator;
import de.tomalbrc.bil.core.component.AnimationComponent;
import de.tomalbrc.bil.core.component.VariantComponent;
import de.tomalbrc.bil.core.element.PerPlayerBlockDisplayElement;
import de.tomalbrc.bil.core.element.PerPlayerItemDisplayElement;
import de.tomalbrc.bil.core.element.PerPlayerTextDisplayElement;
import de.tomalbrc.bil.core.element.PerPlayerTransformableElement;
import de.tomalbrc.bil.core.holder.base.AbstractElementHolder;
import de.tomalbrc.bil.core.holder.wrapper.BlockBone;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.DisplayWrapper;
import de.tomalbrc.bil.core.holder.wrapper.ItemBone;
import de.tomalbrc.bil.core.holder.wrapper.Locator;
import de.tomalbrc.bil.core.holder.wrapper.ModelBone;
import de.tomalbrc.bil.core.holder.wrapper.TextBone;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.core.model.Node;
import de.tomalbrc.bil.core.model.Pose;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public abstract class AbstractAnimationHolder
extends AbstractElementHolder
implements AnimatedHolder {
    protected final Model model;
    protected final AnimationComponent animationComponent;
    protected final VariantComponent variantComponent;
    protected final Object2ObjectOpenHashMap<String, Locator> locatorMap;
    protected Bone<?>[] bones;
    protected Locator[] locators;
    protected float scale = 1.0f;
    protected int color = -1;

    @Deprecated(forRemoval=true)
    protected AbstractAnimationHolder(Model model, class_3218 level) {
        this(model);
    }

    protected AbstractAnimationHolder(Model model) {
        this.model = model;
        this.animationComponent = new AnimationComponent(model, this);
        this.variantComponent = new VariantComponent(model, this);
        this.locatorMap = new Object2ObjectOpenHashMap();
    }

    @Override
    protected final void initializeElements() {
        ObjectArrayList bones = new ObjectArrayList();
        this.setupElements((List<Bone<?>>)bones);
        this.locators = new Locator[this.locatorMap.size()];
        this.bones = new Bone[bones.size()];
        int index = 0;
        for (Locator locator : this.locatorMap.values()) {
            this.locators[index++] = locator;
        }
        for (index = 0; index < bones.size(); ++index) {
            this.bones[index] = (Bone)bones.get(index);
        }
    }

    public void addBoneDataTracker(class_3222 serverPlayer) {
        for (int i = 0; i < this.getBones().length; ++i) {
            Bone<?> bone = this.getBones()[i];
            bone.setLastPose(serverPlayer, bone.getLastPose(null), bone.getLastAnimation(null));
            bone.element().addDataTracker(serverPlayer);
        }
    }

    public void resetBoneDataTracker(class_3222 serverPlayer) {
        for (int i = 0; i < this.getBones().length; ++i) {
            Bone<?> bone = this.getBones()[i];
            bone.resetLastPose(serverPlayer);
            bone.element().resetDataTracker(serverPlayer);
        }
    }

    @Nullable
    protected PerPlayerItemDisplayElement createBoneDisplay(class_2960 modelData) {
        if (modelData == null) {
            return null;
        }
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_18138);
        itemStack.method_57379(class_9334.field_54199, (Object)modelData);
        itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(-1));
        PerPlayerItemDisplayElement element = this.createItemDisplayElement(itemStack);
        element.setItemDisplayContext(class_811.field_4316);
        return element;
    }

    @NotNull
    protected PerPlayerItemDisplayElement createItemDisplayElement(class_1799 item) {
        PerPlayerItemDisplayElement element = new PerPlayerItemDisplayElement(item);
        element.setInterpolationDuration(3);
        element.setTeleportDuration(3);
        element.setInvisible(true);
        return element;
    }

    @NotNull
    protected PerPlayerBlockDisplayElement createBlockDisplayElement(class_2680 blockState) {
        PerPlayerBlockDisplayElement element = new PerPlayerBlockDisplayElement(blockState);
        element.setInterpolationDuration(3);
        element.setTeleportDuration(3);
        element.setInvisible(true);
        return element;
    }

    @NotNull
    protected PerPlayerTextDisplayElement createTextDisplayElement(class_2561 text) {
        PerPlayerTextDisplayElement element = new PerPlayerTextDisplayElement(text);
        element.setInterpolationDuration(3);
        element.setTeleportDuration(3);
        return element;
    }

    protected void setupElements(List<Bone<?>> bones) {
        block7: for (Node node : this.model.nodeMap().values()) {
            Pose defaultPose = (Pose)this.model.defaultPose().get((Object)node.uuid());
            switch (node.type()) {
                case BONE: {
                    PerPlayerTransformableElement bone = this.createBoneDisplay(node.modelData());
                    if (bone == null) continue block7;
                    bones.add(ModelBone.of(bone, node, defaultPose));
                    this.addElement((VirtualElement)bone);
                    break;
                }
                case ITEM: {
                    if (node.displayDataElement() == null) break;
                    PerPlayerTransformableElement bone = this.createItemDisplayElement(((class_1792)class_7923.field_41178.method_63535(node.displayDataElement().getItem())).method_7854());
                    bones.add(ItemBone.of(bone, node, defaultPose));
                    this.addElement((VirtualElement)bone);
                    break;
                }
                case BLOCK: {
                    if (node.displayDataElement() == null) break;
                    PerPlayerTransformableElement bone = this.createBlockDisplayElement(((class_2248)class_7923.field_41175.method_63535(node.displayDataElement().getBlock())).method_9564());
                    bones.add(BlockBone.of((PerPlayerBlockDisplayElement)bone, node, defaultPose));
                    this.addElement((VirtualElement)bone);
                    break;
                }
                case TEXT: {
                    if (node.displayDataElement() == null) break;
                    PerPlayerTransformableElement bone = this.createTextDisplayElement((class_2561)class_2561.method_43470((String)node.displayDataElement().getText()));
                    bones.add(TextBone.of((PerPlayerTextDisplayElement)bone, node, defaultPose));
                    this.addElement((VirtualElement)bone);
                    break;
                }
                case LOCATOR: {
                    this.locatorMap.put((Object)node.name(), (Object)Locator.of(node, defaultPose));
                }
            }
        }
    }

    @Override
    protected void onDataLoaded() {
        for (Bone<?> bone : this.bones) {
            this.initializeDisplay(bone);
        }
    }

    @Override
    protected boolean shouldSkipTick() {
        return false;
    }

    protected void onTick() {
        this.animationComponent.tickAnimations();
    }

    @Override
    protected void onAsyncTick() {
        ((Stream)Arrays.stream(this.watchingPlayers).parallel()).forEach(this::asyncTickFor);
    }

    protected void asyncTickFor(class_3244 watchingPlayer) {
        for (int boneIdx = 0; boneIdx < this.bones.length; ++boneIdx) {
            this.updateElement(watchingPlayer.field_14140, this.bones[boneIdx]);
        }
        for (int locatorIdx = 0; locatorIdx < this.locators.length; ++locatorIdx) {
            this.updateLocator(watchingPlayer.field_14140, this.locators[locatorIdx]);
        }
    }

    public void initializeDisplay(DisplayWrapper<?> display) {
        this.updateElement(null, display, display.getDefaultPose());
    }

    protected void updateElement(class_3222 serverPlayer, DisplayWrapper<?> display) {
        AnimationComponent.PoseQueryResult queryResult = this.animationComponent.findPose(serverPlayer, display);
        if (queryResult != null) {
            if (queryResult.owner() != serverPlayer && display.element().getDataTracker().isDirty()) {
                return;
            }
            this.updateElement(queryResult.owner(), display, queryResult.pose());
        }
    }

    public void updateElement(@Nullable class_3222 serverPlayer, DisplayWrapper<?> display, @Nullable Pose pose) {
        if (pose != null) {
            this.applyPose(serverPlayer, pose, display);
        } else {
            this.applyPose(serverPlayer, display.getLastPose(serverPlayer), display);
        }
    }

    protected void updateLocator(class_3222 serverPlayer, Locator locator) {
        AnimationComponent.PoseQueryResult queryResult;
        if (locator.requiresUpdate() && (queryResult = this.animationComponent.findPose(serverPlayer, locator)) != null) {
            Pose pose;
            Pose pose2 = pose = queryResult.pose() == null ? locator.getLastPose(serverPlayer) : queryResult.pose();
            if (pose != null) {
                locator.updateListeners(queryResult.owner(), this, pose);
            }
        }
    }

    protected void applyPose(class_3222 serverPlayer, Pose pose, DisplayWrapper<?> display) {
        if (this.scale != 1.0f) {
            display.element().setScale(serverPlayer, (Vector3fc)pose.scale().mul(this.scale));
            display.element().setTranslation(serverPlayer, (Vector3fc)pose.translation().mul(this.scale));
        } else {
            display.element().setScale(serverPlayer, pose.readOnlyScale());
            display.element().setTranslation(serverPlayer, pose.readOnlyTranslation());
        }
        display.element().setLeftRotation(serverPlayer, pose.readOnlyLeftRotation());
        display.element().setRightRotation(serverPlayer, pose.readOnlyRightRotation());
        display.element().startInterpolationIfDirty(serverPlayer);
    }

    @Override
    public void setColor(int color) {
        if (color != this.color) {
            this.color = color;
            for (int i = 0; i < this.bones.length; ++i) {
                Bone<?> bone = this.bones[i];
                if (!(bone instanceof ItemBone)) continue;
                ItemBone itemBone = (ItemBone)bone;
                itemBone.updateColor(color);
            }
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Locator getLocator(String name) {
        return (Locator)this.locatorMap.get((Object)name);
    }

    @Override
    public VariantComponent getVariantController() {
        return this.variantComponent;
    }

    @Override
    public Animator getAnimator() {
        return this.animationComponent;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    public Bone<?>[] getBones() {
        return this.bones;
    }

    public Locator[] getLocators() {
        return this.locators;
    }

    public abstract class_2168 createCommandSourceStack();

    public class_3419 getSoundSource() {
        return class_3419.field_15245;
    }
}

