/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.bil.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;

public class SimpleCodecDeserializer<T>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    private final Codec<T> codec;

    public SimpleCodecDeserializer(Codec<T> codec) {
        this.codec = codec;
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return (T)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(error -> new JsonParseException("Failed to deserialize using Codec: " + error));
    }

    public JsonElement serialize(T t, Type type, JsonSerializationContext jsonSerializationContext) {
        return (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, t).getOrThrow(error -> new JsonParseException("Failed to serialize using Codec: " + error));
    }
}

